/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.dimension.market;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.util.BoundingBoxUtil;
import com.feywild.feywild.world.dimension.market.MarketData;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;

public class MarketGenerator {
    public static final BlockPos BASE_POS = new BlockPos(-10, 57, -10);
    public static final List<EntityType<?>> LIVESTOCK = ImmutableList.of((Object)EntityType.field_200796_j, (Object)EntityType.field_200784_X, (Object)EntityType.field_200737_ac, (Object)EntityType.field_200762_B, (Object)EntityType.field_200795_i, (Object)EntityType.field_200769_I);
    private static final Map<ResourceLocation, DwarfEntry> DWARVES = new HashMap<ResourceLocation, DwarfEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMarketDwarf(ResourceLocation id, EntityType<?> type, BlockPos position) {
        Map<ResourceLocation, DwarfEntry> map = DWARVES;
        synchronized (map) {
            if (DWARVES.containsKey(id)) {
                throw new IllegalStateException("Dwarf entry registered twice: " + id);
            }
            DWARVES.put(id, new DwarfEntry(type, position.func_185334_h()));
        }
    }

    public static void generate(ServerWorld world) {
        MarketData data = MarketData.get(world);
        if (data != null && data.tryGenerate()) {
            MarketGenerator.generateBase(world);
            for (DwarfEntry entry : DWARVES.values()) {
                Entity entity = entry.type.func_200721_a((World)world);
                if (entity == null) continue;
                entity.func_70107_b((double)entry.position.func_177958_n() + 0.5, (double)entry.position.func_177956_o(), (double)entry.position.func_177952_p() + 0.5);
                world.func_217376_c(entity);
            }
        }
    }

    private static void generateBase(ServerWorld world) {
        Template template = world.func_184163_y().func_200219_b(new ResourceLocation(FeywildMod.getInstance().modid, "market"));
        if (template != null) {
            template.func_237152_b_((IServerWorld)world, BASE_POS, new PlacementSettings(), world.field_73012_v);
        }
        AxisAlignedBB aabb = BoundingBoxUtil.get(template.func_215388_b(new PlacementSettings(), BASE_POS)).func_186662_g(10.0);
        world.func_72839_b(null, aabb).stream().filter(e -> !(e instanceof PlayerEntity)).forEach(Entity::func_70106_y);
        for (int i = 0; i < 4; ++i) {
            MarketGenerator.addLivestock(world, -3.5, 63.0, 1.5);
        }
    }

    private static void addLivestock(ServerWorld world, double x, double y, double z) {
        EntityType<?> type = LIVESTOCK.get(world.field_73012_v.nextInt(LIVESTOCK.size()));
        Entity entity = type.func_200721_a((World)world);
        if (entity != null) {
            entity.func_70107_b(x, y, z);
            world.func_217376_c(entity);
        }
    }

    private static class DwarfEntry {
        public final EntityType<?> type;
        public final BlockPos position;

        public DwarfEntry(EntityType<?> type, BlockPos position) {
            this.type = type;
            this.position = position;
        }
    }
}

