/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.dimension.market;

import com.feywild.feywild.FeyPlayerData;
import com.feywild.feywild.world.dimension.ModDimensions;
import com.feywild.feywild.world.dimension.SimpleTeleporter;
import com.feywild.feywild.world.dimension.market.MarketData;
import com.feywild.feywild.world.dimension.market.MarketGenerator;
import io.github.noeppi_noeppi.libx.util.NBTX;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class MarketHandler {
    public static void update(MinecraftServer server) {
        MarketData data;
        ServerWorld market = server.func_71218_a(ModDimensions.MARKET_PLACE_DIMENSION);
        if (market != null && (data = MarketData.get(market)) != null) {
            data.update(server, () -> market.func_217490_a(player -> true).forEach(player -> {
                MarketHandler.teleportToOverworld(player);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.feywild.market_closed"), false);
            }));
        }
    }

    public static boolean teleportToMarket(ServerPlayerEntity player) {
        if (player.func_71121_q().func_234923_W_() == World.field_234918_g_) {
            MarketData data;
            ServerWorld targetLevel = player.func_71121_q().func_73046_m().func_71218_a(ModDimensions.MARKET_PLACE_DIMENSION);
            if (targetLevel != null && (data = MarketData.get(targetLevel)) != null) {
                if (data.isOpen()) {
                    NBTX.putPos((CompoundNBT)FeyPlayerData.get((PlayerEntity)player), (String)"DwarfMarketPos", (BlockPos)player.func_233580_cy_().func_185334_h());
                    MarketGenerator.generate(targetLevel);
                    player.changeDimension(targetLevel, (ITeleporter)new SimpleTeleporter(new BlockPos(2, 61, 10)));
                    player.func_195064_c(new EffectInstance(Effects.field_76440_q, 60, 0));
                    player.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 63));
                    return true;
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.feywild.market_closed"), false);
            }
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.feywild.market_wrong_source"), false);
        }
        return false;
    }

    public static boolean teleportToOverworld(ServerPlayerEntity player) {
        if (player.func_71121_q().func_234923_W_() == ModDimensions.MARKET_PLACE_DIMENSION) {
            ServerWorld targetLevel = player.func_71121_q().func_73046_m().func_241755_D_();
            BlockPos targetPos = NBTX.getPos((CompoundNBT)FeyPlayerData.get((PlayerEntity)player), (String)"DwarfMarketPos", null);
            if (targetPos == null) {
                targetPos = player.func_241141_L_() == World.field_234918_g_ & player.func_241140_K_() != null ? player.func_241140_K_() : targetLevel.func_241135_u_();
            }
            if (targetPos == null) {
                targetPos = new BlockPos(0, 64, 0);
            }
            player.changeDimension(targetLevel, (ITeleporter)new SimpleTeleporter(targetPos));
            player.func_195064_c(new EffectInstance(Effects.field_76440_q, 60, 0));
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 63));
            return true;
        }
        return false;
    }
}

