/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.feywild.feywild.block.trees.BaseTree;
import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class BaseSaplingBlock
extends BushBlock
implements IGrowable,
Registerable {
    public static final IntegerProperty STAGE = BlockStateProperties.field_208137_al;
    private final BaseTree tree;
    private final BlockItem item;

    public BaseSaplingBlock(ModX mod, BaseTree tree) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196674_t));
        this.tree = tree;
        Item.Properties properties = mod.tab == null ? new Item.Properties() : new Item.Properties().func_200916_a(mod.tab);
        this.item = new BlockItem((Block)this, properties);
    }

    public Set<Object> getAdditionalRegisters() {
        return ImmutableSet.of((Object)this.item);
    }

    public void registerCommon(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> ComposterBlock.func_220290_a((float)0.4f, (IItemProvider)this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_()));
    }

    public boolean func_176473_a(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.5;
    }

    public boolean func_149653_t(@Nonnull BlockState state) {
        return true;
    }

    public void func_225542_b_(@Nonnull BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        super.func_225542_b_(state, world, pos, rand);
        if (world.isAreaLoaded(pos, 1) && world.func_201696_r(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
            this.func_225535_a_(world, rand, pos, state);
        }
    }

    public void func_225535_a_(@Nonnull ServerWorld world, @Nonnull Random random, @Nonnull BlockPos pos, BlockState state) {
        if ((Integer)state.func_177229_b((Property)STAGE) == 0) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(1)), 4);
        } else if (ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)random, (BlockPos)pos) && this.tree.func_230339_a_(world, world.func_72863_F().func_201711_g(), pos, state, random)) {
            for (int xd = -4; xd <= 4; ++xd) {
                block1: for (int zd = -4; zd <= 4; ++zd) {
                    for (int yd = 2; yd >= -2; --yd) {
                        BlockPos target = pos.func_177982_a(xd, yd, zd);
                        if (!world.func_180495_p(target).func_196958_f() && !world.func_180495_p(target).func_185904_a().func_76222_j() || !world.func_180495_p(target.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP)) continue;
                        this.tree.decorateSaplingGrowth(world, target, random);
                        continue block1;
                    }
                }
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STAGE});
    }
}

