/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.MegaJungleTrunkPlacer;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DecoratingGiantTrunkPlacer
extends MegaJungleTrunkPlacer {
    public DecoratingGiantTrunkPlacer(int p_i232058_1_, int p_i232058_2_, int p_i232058_3_) {
        super(p_i232058_1_, p_i232058_2_, p_i232058_3_);
    }

    private void tryPlaceLog(IWorldGenerationReader world, Random random, BlockPos.Mutable pos, Set<BlockPos> blocks, MutableBoundingBox box, BaseTreeFeatureConfig config, BlockPos target, int offsetX, int offsetY, int offsetZ, List<Pair<BlockPos, BlockState>> decoratables) {
        pos.func_239621_a_((Vector3i)target, offsetX, offsetY, offsetZ);
        if (TreeFeature.func_236410_c_((IWorldGenerationBaseReader)world, (BlockPos)pos) && DecoratingGiantTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)pos, blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config) && world instanceof ISeedReader) {
            decoratables.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos.func_185334_h(), (Object)((ISeedReader)world).func_180495_p((BlockPos)pos)));
        }
    }

    private List<FoliagePlacer.Foliage> placeBaseTrunk(@Nonnull IWorldGenerationReader world, @Nonnull Random random, int height, @Nonnull BlockPos pos, @Nonnull Set<BlockPos> blocks, @Nonnull MutableBoundingBox box, @Nonnull BaseTreeFeatureConfig config, List<Pair<BlockPos, BlockState>> decoratables) {
        BlockPos blockpos = pos.func_177977_b();
        DecoratingGiantTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos);
        DecoratingGiantTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177974_f());
        DecoratingGiantTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177968_d());
        DecoratingGiantTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177968_d().func_177974_f());
        BlockPos.Mutable current = new BlockPos.Mutable();
        for (int i = 0; i < height; ++i) {
            this.tryPlaceLog(world, random, current, blocks, box, config, pos, 0, i, 0, decoratables);
            if (i >= height - 1) continue;
            this.tryPlaceLog(world, random, current, blocks, box, config, pos, 1, i, 0, decoratables);
            this.tryPlaceLog(world, random, current, blocks, box, config, pos, 1, i, 1, decoratables);
            this.tryPlaceLog(world, random, current, blocks, box, config, pos, 0, i, 1, decoratables);
        }
        return ImmutableList.of((Object)new FoliagePlacer.Foliage(pos.func_177981_b(height), 0, true));
    }

    @Nonnull
    public List<FoliagePlacer.Foliage> func_230382_a_(@Nonnull IWorldGenerationReader world, @Nonnull Random random, int height, @Nonnull BlockPos pos, @Nonnull Set<BlockPos> blocks, @Nonnull MutableBoundingBox box, @Nonnull BaseTreeFeatureConfig config) {
        ArrayList list = Lists.newArrayList();
        ArrayList<Pair<BlockPos, BlockState>> decoratables = new ArrayList<Pair<BlockPos, BlockState>>();
        list.addAll(this.placeBaseTrunk(world, random, height, pos, blocks, box, config, decoratables));
        for (int y = height - 2 - random.nextInt(4); y > height / 2; y -= 2 + random.nextInt(4)) {
            float f = random.nextFloat() * ((float)Math.PI * 2);
            int x = 0;
            int z = 0;
            for (int i = 0; i < 5; ++i) {
                x = (int)(1.5f + MathHelper.func_76134_b((float)f) * (float)i);
                BlockPos logPos = pos.func_177982_a(x, y - 3 + i / 2, z = (int)(1.5f + MathHelper.func_76126_a((float)f) * (float)i));
                if (!DecoratingGiantTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)logPos, blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config) || !(world instanceof ISeedReader)) continue;
                decoratables.add((Pair<BlockPos, BlockState>)Pair.of((Object)logPos.func_185334_h(), (Object)((ISeedReader)world).func_180495_p(logPos)));
            }
            list.add(new FoliagePlacer.Foliage(pos.func_177982_a(x, y, z), -2, false));
        }
        if (world instanceof ISeedReader) {
            for (Pair pair : decoratables) {
                if (!((ISeedReader)world).func_180495_p((BlockPos)pair.getLeft()).equals(pair.getRight())) continue;
                this.decorateLog((BlockState)pair.getRight(), (ISeedReader)world, (BlockPos)pair.getLeft(), random);
            }
        }
        return list;
    }

    protected abstract void decorateLog(BlockState var1, ISeedReader var2, BlockPos var3, Random var4);
}

