/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.feywild.feywild.config.ClientConfig;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.BlockBase;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolType;

public class FeyLeavesBlock
extends BlockBase
implements Registerable,
IForgeShearable {
    public static final int MAX_DISTANCE = 15;
    public static final IntegerProperty DISTANCE = IntegerProperty.func_177719_a((String)"distance", (int)0, (int)15);
    public static final int MAX_PARTICLE_DISTANCE = 48;
    private final int chance;
    private final BasicParticleType particle;

    public FeyLeavesBlock(ModX mod, int chance, BasicParticleType particle) {
        super(mod, AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).harvestTool(ToolType.HOE).func_226896_b_().func_235827_a_((s, r, p, t) -> false).func_235842_b_((s, r, p) -> false).func_235847_c_((s, r, p) -> false));
        this.chance = chance;
        this.particle = particle;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BlockStateProperties.field_208515_s, (Comparable)Boolean.valueOf(false)));
    }

    public void registerCommon(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> ComposterBlock.func_220290_a((float)0.4f, (IItemProvider)this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_()));
    }

    protected static BlockState updateDistance(BlockState state, IWorld worldIn, BlockPos pos) {
        int distance = 15;
        BlockPos.Mutable current = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            if (distance <= 1) continue;
            current.func_239622_a_((Vector3i)pos, direction);
            distance = Math.min(distance, FeyLeavesBlock.getDistance(worldIn.func_180495_p((BlockPos)current)) + 1);
        }
        return (BlockState)state.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    private static int getDistance(BlockState neighbor) {
        if (BlockTags.field_200031_h.func_230235_a_((Object)neighbor.func_177230_c())) {
            return 0;
        }
        if (neighbor.func_177230_c() instanceof FeyLeavesBlock) {
            return (Integer)neighbor.func_177229_b((Property)DISTANCE);
        }
        return 15;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DISTANCE, BlockStateProperties.field_208515_s});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return FeyLeavesBlock.updateDistance((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208515_s, (Comparable)Boolean.valueOf(true)), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    @Nonnull
    public VoxelShape func_230335_e_(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)DISTANCE) == 15 && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208515_s) == false;
    }

    public void func_225542_b_(@Nonnull BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, @Nonnull Random random) {
        FeyLeavesBlock.updateDistance(state, (IWorld)world, pos);
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208515_s)).booleanValue() && (Integer)state.func_177229_b((Property)DISTANCE) == 15) {
            FeyLeavesBlock.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_217377_a(pos, false);
        }
    }

    public void func_225534_a_(@Nonnull BlockState state, ServerWorld worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        worldIn.func_180501_a(pos, FeyLeavesBlock.updateDistance(state, (IWorld)worldIn, pos), 3);
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        int distance = FeyLeavesBlock.getDistance(facingState) + 1;
        if (distance != 1 || (Integer)state.func_177229_b((Property)DISTANCE) != distance) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (ClientConfig.tree_particles) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && mc.field_71439_g.func_213303_ch().func_186679_c((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 2304.0) {
                this.animateLeaves(state, world, pos, rand);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void animateLeaves(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(rand.nextInt(15) != 0 || !world.func_175727_C(pos.func_177984_a()) || (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)world, blockpos, Direction.UP))) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() - 0.05;
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            world.func_195594_a((IParticleData)ParticleTypes.field_197618_k, x, y, z, 0.0, 0.0, 0.0);
        }
        if (rand.nextInt(this.chance) == 1 && world.func_175623_d(pos.func_177977_b())) {
            world.func_195594_a((IParticleData)this.particle, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + rand.nextDouble(), 1.0, -0.1, 0.0);
        }
    }
}

