/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity;

import com.feywild.feywild.config.MobConfig;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.entity.base.FeyBase;
import com.feywild.feywild.entity.base.FlyingFeyBase;
import com.feywild.feywild.entity.base.IAnger;
import com.feywild.feywild.entity.goals.BeeRestrictAttackGoal;
import com.feywild.feywild.entity.goals.FeyAttackableTargetGoal;
import com.feywild.feywild.entity.goals.ReturnToPositionKnightGoal;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.sound.ModSoundEvents;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class BeeKnightEntity
extends FlyingFeyBase
implements IAnimatable,
IAnger {
    public static final DataParameter<Boolean> AGGRAVATED = EntityDataManager.func_187226_a(BeeKnightEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public BeeKnightEntity(EntityType<? extends BeeKnightEntity> type, World world) {
        super((EntityType<? extends FeyBase>)type, Alignment.SUMMER, world);
    }

    public static boolean canSpawn(EntityType<? extends BeeKnightEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return Tags.Blocks.DIRT.func_230235_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c()) || Tags.Blocks.SAND.func_230235_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c());
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return FlyingFeyBase.getDefaultAttributes().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233819_b_, 80.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233822_e_, 2.25);
    }

    public static void anger(World world, PlayerEntity player, BlockPos pos) {
        QuestData quests;
        if (!world.field_72995_K && player instanceof ServerPlayerEntity && ((quests = QuestData.get((ServerPlayerEntity)player)).getAlignment() != Alignment.SUMMER || quests.getReputation() < MobConfig.summer_bee_knight.required_reputation)) {
            AxisAlignedBB aabb = new AxisAlignedBB(pos).func_186662_g((double)(2 * MobConfig.summer_bee_knight.aggrevation_range));
            world.func_217394_a(ModEntityTypes.beeKnight, aabb, entity -> true).forEach(entity -> {
                if (entity.getCurrentPointOfInterest() != null && pos.func_218137_a((IPosition)entity.getCurrentPointOfInterest(), (double)MobConfig.summer_bee_knight.aggrevation_range) && player.func_110124_au() != entity.getOwnerId()) {
                    entity.func_70624_b((LivingEntity)player);
                    entity.setAngry(true);
                }
            });
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason reason, @Nullable ILivingEntityData data, @Nullable CompoundNBT nbt) {
        this.setCurrentTargetPos(this.func_233580_cy_());
        return super.func_213386_a(world, difficulty, reason, data, nbt);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(50, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(2, new FeyAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new BeeRestrictAttackGoal(this, 1.2f, true));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(30, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new ReturnToPositionKnightGoal((MobEntity)this, this::getCurrentPointOfInterest, this.getMovementRange(), 1.5f));
        this.field_70714_bg.func_75776_a(30, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    protected int getMovementRange() {
        return MobConfig.summer_bee_knight.aggrevation_range;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70737_aN > 0 && this.func_70643_av() != this.getOwner()) {
            this.func_70624_b(this.func_70643_av());
            this.setAngry(true);
        }
    }

    @Override
    public BasicParticleType getParticle() {
        return ParticleTypes.field_197614_g;
    }

    @Nonnull
    public ActionResultType func_184199_a(@Nonnull PlayerEntity player, @Nonnull Vector3d hitVec, @Nonnull Hand hand) {
        if (!player.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            QuestData quests = QuestData.get((ServerPlayerEntity)player);
            if (quests.getAlignment() == Alignment.SUMMER && quests.getReputation() >= MobConfig.summer_bee_knight.required_reputation && this.getOwner() == null || player.func_110124_au() == this.owner) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild.bee_knight_pass"), player.func_110124_au());
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild.bee_knight_fail"), player.func_110124_au());
            }
        }
        return ActionResultType.SUCCESS;
    }

    private <E extends IAnimatable> PlayState flyingPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bee_knight.fly", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController flyingController = new AnimationController((IAnimatable)this, "flyingController", 0.0f, this::flyingPredicate);
        animationData.addAnimationController(flyingController);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGGRAVATED, (Object)false);
    }

    public boolean func_70652_k(@Nonnull Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            ((LivingEntity)pEntity).func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 1));
        }
        return super.func_70652_k(pEntity);
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damage) {
        return this.field_70146_Z.nextBoolean() ? ModSoundEvents.pixieHurt : SoundEvents.field_226125_Z_;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.field_70146_Z.nextBoolean() ? ModSoundEvents.pixieDeath : SoundEvents.field_226124_Y_;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_226127_ab_;
    }

    @Override
    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(AGGRAVATED);
    }

    @Override
    public void setAngry(boolean value) {
        this.field_70180_af.func_187227_b(AGGRAVATED, (Object)value);
    }
}

