/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.entity.base.FeyBase;
import com.feywild.feywild.entity.base.GroundFeyBase;
import com.feywild.feywild.entity.base.ITameable;
import com.feywild.feywild.entity.goals.GoToTargetPositionGoal;
import com.feywild.feywild.entity.goals.SneezeGoal;
import com.feywild.feywild.entity.goals.WaveGoal;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.sound.ModSoundEvents;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.ComposterBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ShroomlingEntity
extends GroundFeyBase
implements IAnimatable,
ITameable {
    public static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(ShroomlingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final double MIN_MOVING_SPEED_SQR = 0.0025000000000000005;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean isTamed = false;

    protected ShroomlingEntity(EntityType<? extends FeyBase> entityType, World world) {
        super(entityType, Alignment.AUTUMN, world);
        this.field_70765_h = new MovementController((MobEntity)this);
        this.field_70158_ak = true;
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, Attributes.field_233821_d_.func_111110_b()).func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.1);
    }

    public static boolean canSpawn(EntityType<? extends ShroomlingEntity> entity, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return Tags.Blocks.DIRT.func_230235_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c()) || Tags.Blocks.SAND.func_230235_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c());
    }

    @Override
    @Nullable
    public Vector3d getCurrentPointOfInterest() {
        if (!this.isTamed()) {
            return null;
        }
        if (this.summonPos != null) {
            return this.summonPos.func_72441_c(0.5, 0.5, 0.5);
        }
        PlayerEntity player = this.getOwner();
        if (player != null) {
            return player.func_213303_ch();
        }
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)0);
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("Tamed", this.isTamed);
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.isTamed = nbt.func_74767_n("Tamed");
    }

    @Override
    @Nullable
    public BasicParticleType getParticle() {
        return null;
    }

    @Override
    public boolean isTamed() {
        return this.isTamed;
    }

    public void setTamed(boolean tamed) {
        this.isTamed = tamed;
    }

    public State getState() {
        State[] states = State.values();
        return states[MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state.ordinal());
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(50, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, (double)0.1f, 8.0f));
        this.field_70714_bg.func_75776_a(20, (Goal)new GoToTargetPositionGoal((MobEntity)this, this::getCurrentPointOfInterest, this.getMovementRange(), 1.0f));
        this.field_70714_bg.func_75776_a(60, (Goal)new WaveGoal(this));
        this.field_70714_bg.func_75776_a(30, (Goal)new SneezeGoal(this));
    }

    protected void func_213385_F() {
        super.func_213385_F();
        this.field_70714_bg.func_220878_a(Goal.Flag.MOVE, true);
        this.field_70714_bg.func_220878_a(Goal.Flag.JUMP, true);
        this.field_70714_bg.func_220878_a(Goal.Flag.LOOK, true);
    }

    @Override
    public boolean func_70617_f_() {
        return false;
    }

    @Override
    protected int func_225508_e_(float distance, float damageMultiplier) {
        return 0;
    }

    @Override
    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    protected int func_70693_a(@Nonnull PlayerEntity player) {
        return 0;
    }

    @Override
    public boolean func_184652_a(@Nonnull PlayerEntity player) {
        return false;
    }

    @Override
    protected boolean func_184228_n(@Nonnull Entity entityIn) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return ModSoundEvents.shroomlingHurt;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.shroomlingDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextBoolean() ? ModSoundEvents.shroomlingAmbience : null;
    }

    @Nonnull
    public ActionResultType func_184199_a(PlayerEntity player, @Nonnull Vector3d vec, @Nonnull Hand hand) {
        ItemStack itemstack;
        if (!this.field_70170_p.field_72995_K && player.func_225608_bj_() && this.owner != null && this.owner.equals(player.func_110124_au())) {
            if (Objects.equals(this.getCurrentPointOfInterest(), player.func_213303_ch())) {
                this.setOrderedToStay();
            } else {
                this.setOrderedToFollow();
            }
        }
        if (ComposterBlock.field_220299_b.containsKey((Object)(itemstack = player.func_184586_b(hand)).func_77973_b()) && player == this.getOwner()) {
            if (!this.field_70170_p.field_72995_K) {
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                FeywildMod.getNetwork().sendParticles(this.field_70170_p, ParticleSerializer.Type.CROPS_GROW, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                player.func_226292_a_(hand, true);
                this.func_199701_a_(new ItemStack((IItemProvider)Items.field_196106_bc));
                this.func_184185_a(SoundEvents.field_219623_bk, 1.0f, 0.6f);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.CONSUME;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!this.field_70729_aU && !this.func_233643_dh_()) {
            if (this.getState() == State.WAVING) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shroomling.wave", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            if (this.getState() == State.SNEEZING) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shroomling.sneeze", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
        }
        if (this.func_213322_ci().func_189985_c() < 0.0025000000000000005) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shroomling.static", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shroomling.walk", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_104002_bU() {
        return this.isTamed;
    }

    public static enum State {
        IDLE,
        WAVING,
        SNEEZING;

    }
}

