/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.base;

import com.feywild.feywild.entity.goals.GoToTargetPositionGoal;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.sound.ModSoundEvents;
import io.github.noeppi_noeppi.libx.util.NBTX;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class FeyBase
extends CreatureEntity
implements IAnimatable {
    public final Alignment alignment;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public Vector3d summonPos = null;
    @Nullable
    protected UUID owner;
    private boolean orderedToStay;

    protected FeyBase(EntityType<? extends CreatureEntity> entityType, Alignment alignment, World world) {
        super(entityType, world);
        this.alignment = alignment;
        this.field_70158_ak = true;
    }

    @Nullable
    public PlayerEntity getOwner() {
        return this.owner == null ? null : this.field_70170_p.func_217371_b(this.owner);
    }

    public void setOwner(@Nullable PlayerEntity owner) {
        this.setOwner(owner == null ? null : owner.func_110124_au());
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    @Nullable
    public UUID getOwnerId() {
        return this.owner;
    }

    @Nullable
    public Vector3d getCurrentPointOfInterest() {
        return this.summonPos;
    }

    public void setCurrentTargetPos(@Nullable BlockPos currentTargetPos) {
        this.summonPos = currentTargetPos == null ? null : new Vector3d((double)currentTargetPos.func_177958_n(), (double)currentTargetPos.func_177956_o(), (double)currentTargetPos.func_177952_p());
    }

    public void setCurrentTargetPos(@Nullable Vector3d currentTargetPos) {
        this.summonPos = currentTargetPos;
    }

    @Nullable
    public abstract BasicParticleType getParticle();

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(30, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new GoToTargetPositionGoal((MobEntity)this, this::getCurrentPointOfInterest, this.getMovementRange(), 1.5f));
        this.field_70714_bg.func_75776_a(30, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected int getMovementRange() {
        return 6;
    }

    public void func_70071_h_() {
        ServerPlayerEntity owner;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(11) == 0 && this.getParticle() != null) {
            this.field_70170_p.func_195594_a((IParticleData)this.getParticle(), this.func_226277_ct_() + (Math.random() - 0.5), this.func_226278_cu_() + 1.0 + (Math.random() - 0.5), this.func_226281_cx_() + (Math.random() - 0.5), 0.0, -0.1, 0.0);
        } else if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 160 == 0 && this.getOwner() instanceof ServerPlayerEntity && this.func_70089_S() && !this.alignment.equals((Object)QuestData.get(owner = (ServerPlayerEntity)this.getOwner()).getAlignment()) && QuestData.get(owner).getAlignment() != null) {
            owner.func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild." + this.getEntity().func_70022_Q().replace("feywild:", "") + ".disappear"), this.getOwnerId());
            this.func_70106_y();
        }
    }

    public boolean func_184207_aI() {
        return false;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return 0;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected int func_70693_a(@Nonnull PlayerEntity player) {
        return 0;
    }

    public boolean func_184652_a(@Nonnull PlayerEntity player) {
        return false;
    }

    protected boolean func_184228_n(@Nonnull Entity entityIn) {
        return false;
    }

    protected float func_70647_i() {
        return 1.0f;
    }

    public boolean func_213392_I() {
        return true;
    }

    public boolean func_213397_c(double distanceSq) {
        return false;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return ModSoundEvents.pixieHurt;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.pixieDeath;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextBoolean() ? ModSoundEvents.pixieAmbient : null;
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void func_213281_b(@Nonnull CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.owner != null) {
            nbt.func_186854_a("Owner", this.owner);
        }
        if (this.getCurrentPointOfInterest() != null) {
            NBTX.putPos((CompoundNBT)nbt, (String)"SummonPos", (BlockPos)new BlockPos(this.getCurrentPointOfInterest().field_72450_a, this.getCurrentPointOfInterest().field_72448_b, this.getCurrentPointOfInterest().field_72449_c));
        }
    }

    public void func_70037_a(@Nonnull CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.owner = nbt.func_186855_b("Owner") ? nbt.func_186857_a("Owner") : null;
        BlockPos pos = NBTX.getPos((CompoundNBT)nbt, (String)"SummonPos", null);
        if (pos != null) {
            this.summonPos = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
    }

    public boolean isOrderedToStay() {
        return this.orderedToStay;
    }

    public void setOrderedToStay() {
        this.orderedToStay = true;
        this.setCurrentTargetPos(this.func_233580_cy_());
        Objects.requireNonNull(this.getOwner()).func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild." + this.alignment.id + "_fey_stay").func_230529_a_((ITextComponent)new TranslationTextComponent("message.feywild.fey_stay").func_240699_a_(TextFormatting.ITALIC)), this.getOwner().func_110124_au());
    }

    public void setOrderedToFollow() {
        this.orderedToStay = false;
        this.setCurrentTargetPos((BlockPos)null);
        Objects.requireNonNull(this.getOwner()).func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild." + this.alignment.id + "_fey_follow").func_230529_a_((ITextComponent)new TranslationTextComponent("message.feywild.fey_follow").func_240699_a_(TextFormatting.ITALIC)), this.getOwner().func_110124_au());
    }

    public void unableToFollow() {
        this.orderedToStay = true;
        this.setCurrentTargetPos(this.func_233580_cy_());
    }
}

