/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.base;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.entity.base.FeyBase;
import com.feywild.feywild.entity.base.FlyingFeyBase;
import com.feywild.feywild.entity.base.ITameable;
import com.feywild.feywild.entity.goals.FeyWildPanicGoal;
import com.feywild.feywild.entity.goals.TameCheckingGoal;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.network.quest.OpenQuestDisplaySerializer;
import com.feywild.feywild.network.quest.OpenQuestSelectionSerializer;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.QuestDisplay;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.quest.task.FeyGiftTask;
import com.feywild.feywild.quest.util.AlignmentStack;
import com.feywild.feywild.quest.util.SelectableQuest;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.PacketDistributor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public abstract class PixieEntity
extends FlyingFeyBase
implements ITameable {
    public static final DataParameter<Boolean> CASTING = EntityDataManager.func_187226_a(PixieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean isTamed = false;

    protected PixieEntity(EntityType<? extends PixieEntity> type, Alignment alignment, World world) {
        super((EntityType<? extends FeyBase>)type, alignment, world);
    }

    public static boolean canSpawn(EntityType<? extends PixieEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return Tags.Blocks.DIRT.func_230235_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c()) || Tags.Blocks.SAND.func_230235_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c());
    }

    @Override
    public boolean isTamed() {
        return this.isTamed;
    }

    public void setTamed(boolean tamed) {
        this.isTamed = tamed;
    }

    @Override
    @Nullable
    public Vector3d getCurrentPointOfInterest() {
        if (!this.isTamed()) {
            return null;
        }
        if (this.summonPos != null) {
            return this.summonPos.func_72441_c(0.5, 0.5, 0.5);
        }
        PlayerEntity player = this.getOwner();
        if (player != null) {
            return player.func_213303_ch();
        }
        return null;
    }

    public boolean isCasting() {
        return (Boolean)this.field_70180_af.func_187225_a(CASTING);
    }

    public void setCasting(boolean casting) {
        this.field_70180_af.func_187227_b(CASTING, (Object)casting);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CASTING, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(50, (Goal)new FeyWildPanicGoal(this, 0.003, 13));
        this.field_70714_bg.func_75776_a(10, (Goal)new TameCheckingGoal(this, false, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151106_aX}), false)));
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("Tamed", this.isTamed);
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.isTamed = nbt.func_74767_n("Tamed");
    }

    @Nonnull
    public ActionResultType func_184199_a(@Nonnull PlayerEntity player, @Nonnull Vector3d hitVec, @Nonnull Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack;
            if (player.func_225608_bj_()) {
                if (this.owner != null && this.owner.equals(player.func_110124_au())) {
                    if (Objects.equals(this.getCurrentPointOfInterest(), player.func_213303_ch())) {
                        this.setOrderedToStay();
                    } else {
                        this.setOrderedToFollow();
                    }
                }
            } else if (player instanceof ServerPlayerEntity && this.tryAcceptGift((ServerPlayerEntity)player, hand)) {
                player.func_226292_a_(hand, true);
            } else if (!(player.func_184586_b(hand).func_77973_b() != Items.field_151106_aX || this.func_70643_av() != null && this.func_70643_av().func_70089_S())) {
                this.func_70691_i(4.0f);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                FeywildMod.getNetwork().sendParticles(this.field_70170_p, ParticleSerializer.Type.FEY_HEART, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                player.func_226292_a_(hand, true);
            } else if (player.func_184586_b(hand).func_77973_b() == Items.field_151057_cb) {
                this.func_200203_b((ITextComponent)new StringTextComponent(player.func_184586_b(hand).func_151000_E().getString().substring(1, player.func_184586_b(hand).func_151000_E().getString().length() - 1)));
                this.func_174805_g(true);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild." + this.alignment.id + "_fey_name"), player.func_110124_au());
            } else if (this.isTamed() && player instanceof ServerPlayerEntity && this.owner != null && this.owner.equals(player.func_110124_au()) && (stack = player.func_184586_b(hand)).func_190926_b()) {
                this.interactQuest((ServerPlayerEntity)player, hand);
            }
        }
        return ActionResultType.CONSUME;
    }

    private void interactQuest(ServerPlayerEntity player, Hand hand) {
        QuestData quests = QuestData.get(player);
        if (quests.canComplete(this.alignment)) {
            QuestDisplay completionDisplay = quests.completePendingQuest();
            if (completionDisplay != null) {
                FeywildMod.getNetwork().instance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(completionDisplay, false));
                player.func_226292_a_(hand, true);
            } else {
                List<SelectableQuest> active = quests.getActiveQuests();
                if (active.size() == 1) {
                    FeywildMod.getNetwork().instance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(active.get((int)0).display, false));
                    player.func_226292_a_(hand, true);
                } else if (!active.isEmpty()) {
                    FeywildMod.getNetwork().instance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestSelectionSerializer.Message(this.func_145748_c_(), this.alignment, active));
                    player.func_226292_a_(hand, true);
                }
            }
        } else {
            QuestDisplay initDisplay = quests.initialize(this.alignment);
            if (initDisplay != null) {
                FeywildMod.getNetwork().instance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(initDisplay, true));
                player.func_226292_a_(hand, true);
            }
        }
    }

    private boolean tryAcceptGift(ServerPlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            AlignmentStack input = new AlignmentStack(this.alignment, stack);
            if (QuestData.get(player).checkComplete(FeyGiftTask.INSTANCE, input)) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild." + this.alignment.id + "_fey_thanks"), player.func_110124_au());
                return true;
            }
        }
        return false;
    }

    private <E extends IAnimatable> PlayState flyingPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.pixie.fly", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState castingPredicate(AnimationEvent<E> event) {
        if (this.isCasting() && !this.field_70729_aU && !this.func_233643_dh_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.pixie.spellcasting", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController flyingController = new AnimationController((IAnimatable)this, "flyingController", 0.0f, this::flyingPredicate);
        AnimationController castingController = new AnimationController((IAnimatable)this, "castingController", 0.0f, this::castingPredicate);
        animationData.addAnimationController(flyingController);
        animationData.addAnimationController(castingController);
    }

    public boolean func_104002_bU() {
        return this.isTamed;
    }
}

