/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.block.entity.DwarvenAnvil;
import com.feywild.feywild.entity.DwarfBlacksmithEntity;
import com.feywild.feywild.entity.goals.MovementRestrictionGoal;
import java.util.function.Supplier;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class GoToAnvilPositionGoal
extends MovementRestrictionGoal {
    private final DwarfBlacksmithEntity entity;
    private DwarvenAnvil tile;
    private int ticksLeft = 0;

    public GoToAnvilPositionGoal(DwarfBlacksmithEntity entity, Supplier<BlockPos> pos, int maxMovementRange) {
        super(GoToAnvilPositionGoal.asVector(pos), maxMovementRange);
        this.entity = entity;
    }

    public void func_75246_d() {
        this.init();
        if (!this.entity.isTamed()) {
            this.reset();
        } else if (this.tile != null && this.ticksLeft > 0) {
            if (!this.tile.canCraft()) {
                this.reset();
                return;
            }
            --this.ticksLeft;
            if (this.ticksLeft == 0) {
                this.tile.craft();
                this.reset();
            } else {
                Vector3d target = (Vector3d)this.targetPosition.get();
                if (target != null && this.tile.canCraft()) {
                    if (this.ticksLeft == 20) {
                        this.entity.func_184185_a(SoundEvents.field_187698_i, 1.0f, 1.0f);
                    } else if (this.ticksLeft == 50) {
                        this.entity.setState(DwarfBlacksmithEntity.State.WORKING);
                    } else if (this.ticksLeft <= 110) {
                        this.entity.func_70661_as().func_75492_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, 0.5);
                        this.entity.func_200602_a(EntityAnchorArgument.Type.EYES, target);
                    }
                } else {
                    this.reset();
                }
            }
        }
    }

    public void func_75249_e() {
        this.ticksLeft = 120;
    }

    protected void reset() {
        this.entity.setState(DwarfBlacksmithEntity.State.IDLE);
        this.ticksLeft = -1;
    }

    public boolean func_75253_b() {
        this.init();
        return this.ticksLeft > 0 && this.entity.isTamed() && this.tile != null && this.targetPosition.get() != null;
    }

    @Override
    public boolean func_75250_a() {
        this.init();
        return this.tile != null && this.targetPosition.get() != null && this.tile.canCraft();
    }

    private void init() {
        if (this.tile == null && this.entity.getSummonPos() != null) {
            TileEntity tile = this.entity.field_70170_p.func_175625_s(this.entity.getSummonPos());
            this.tile = tile instanceof DwarvenAnvil ? (DwarvenAnvil)tile : null;
        }
    }
}

