/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.entity.ShroomlingEntity;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.sound.ModSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class SneezeGoal
extends Goal {
    private static final EntityPredicate TARGETING = new EntityPredicate().func_221009_d().func_221013_a(4.0).func_221014_c();
    protected final World level;
    protected ShroomlingEntity entity;
    private int ticksLeft = 0;
    private AnimalEntity targetAnimal;

    public SneezeGoal(ShroomlingEntity shroomling2) {
        this.entity = shroomling2;
        this.level = shroomling2.field_70170_p;
    }

    public void func_75246_d() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                if (this.targetAnimal == null || !this.targetAnimal.func_70089_S()) {
                    this.targetAnimal = this.findTarget();
                    if (this.targetAnimal != null && this.targetAnimal.func_70089_S()) {
                        MooshroomEntity cow = new MooshroomEntity(EntityType.field_200780_T, this.level);
                        cow.func_70107_b(this.targetAnimal.func_226277_ct_(), this.targetAnimal.func_226278_cu_(), this.targetAnimal.func_226281_cx_());
                        this.targetAnimal.func_70106_y();
                        this.level.func_217376_c((Entity)cow);
                        cow.func_184185_a(SoundEvents.field_219670_hk, 1.0f, 0.6f);
                        FeywildMod.getNetwork().sendParticles(this.entity.field_70170_p, ParticleSerializer.Type.SHROOMLING_SNEEZE, cow.func_226277_ct_(), cow.func_226278_cu_(), cow.func_226281_cx_());
                    }
                }
                if (this.entity.isTamed() && this.level.func_226658_a_(LightType.BLOCK, this.entity.func_233580_cy_()) < 3 && this.entity.field_70170_p.func_180495_p(this.entity.func_233580_cy_()).func_227032_a_((Fluid)Fluids.field_204546_a)) {
                    this.level.func_180501_a(this.entity.func_233580_cy_(), ModBlocks.feyMushroom.func_176223_P(), 2);
                    this.entity.func_184185_a(SoundEvents.field_226132_ag_, 1.0f, 1.0f);
                }
                this.reset();
            } else if (this.ticksLeft == 45) {
                FeywildMod.getNetwork().sendParticles(this.entity.field_70170_p, ParticleSerializer.Type.SHROOMLING_SNEEZE, this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_());
            } else if (this.ticksLeft == 90) {
                this.sneezing();
                this.entity.func_184185_a(ModSoundEvents.shroomlingSneeze, 1.0f, 1.0f);
            }
        }
    }

    private void reset() {
        this.entity.setState(ShroomlingEntity.State.IDLE);
        this.targetAnimal = null;
        this.ticksLeft = -1;
    }

    private void sneezing() {
        this.entity.setState(ShroomlingEntity.State.SNEEZING);
    }

    public void func_75249_e() {
        this.ticksLeft = 100;
        this.targetAnimal = null;
    }

    public boolean func_75250_a() {
        return this.level.field_73012_v.nextFloat() < 0.003f && this.entity.getState() != ShroomlingEntity.State.WAVING;
    }

    public boolean func_75253_b() {
        return this.ticksLeft > 0 && this.entity.getState() != ShroomlingEntity.State.WAVING;
    }

    @Nullable
    private AnimalEntity findTarget() {
        double distance = Double.MAX_VALUE;
        AnimalEntity current = null;
        for (AnimalEntity animal : this.entity.field_70170_p.func_217374_a(CowEntity.class, TARGETING, (LivingEntity)this.entity, this.entity.func_174813_aQ().func_186662_g(8.0))) {
            if (animal.func_70874_b() != 0 || !(this.entity.func_70068_e((Entity)animal) < distance)) continue;
            current = animal;
            distance = this.entity.func_70068_e((Entity)animal);
        }
        return current;
    }
}

