/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.entity.WinterPixieEntity;
import com.feywild.feywild.entity.base.PixieEntity;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.sound.ModSoundEvents;
import java.util.Objects;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;

public class SummonSnowManGoal
extends Goal {
    private static final EntityPredicate TARGETING = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c().func_221012_a(living -> !(living instanceof PixieEntity));
    private final PixieEntity entity;
    private int ticksLeft = 0;
    private Vector3d targetPos;

    public SummonSnowManGoal(WinterPixieEntity entity) {
        this.entity = entity;
    }

    public void func_75246_d() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (!this.noSnowManNearby()) {
                this.reset();
                return;
            }
            if (this.ticksLeft <= 0) {
                this.summonSnowMan();
                this.reset();
            } else if (this.ticksLeft == 110) {
                this.spellCasting();
            } else if (this.ticksLeft <= 100) {
                this.entity.func_200602_a(EntityAnchorArgument.Type.EYES, this.targetPos);
            }
        }
    }

    public void func_75249_e() {
        this.ticksLeft = 120;
        this.entity.setCasting(false);
    }

    private void spellCasting() {
        this.targetPos = new Vector3d(this.entity.func_226277_ct_() + (double)this.entity.func_70681_au().nextInt(8) - 4.0, this.entity.func_226278_cu_() + 2.0, this.entity.func_226281_cx_() + (double)this.entity.func_70681_au().nextInt(8) - 4.0);
        this.entity.setCasting(true);
        this.entity.func_184185_a(ModSoundEvents.pixieSpellcasting, 1.0f, 1.0f);
    }

    private void reset() {
        this.entity.setCasting(false);
        this.targetPos = null;
        this.ticksLeft = -1;
    }

    private void summonSnowMan() {
        SnowGolemEntity snowman = new SnowGolemEntity(EntityType.field_200745_ak, this.entity.field_70170_p);
        snowman.func_70107_b(this.entity.func_226277_ct_(), this.entity.func_226278_cu_() + 1.0, this.entity.func_226281_cx_());
        snowman.func_213293_j((this.targetPos.field_72450_a - this.entity.func_226277_ct_()) / 8.0, (this.targetPos.field_72448_b - this.entity.func_226278_cu_()) / 8.0, (this.targetPos.field_72449_c - this.entity.func_226281_cx_()) / 8.0);
        this.entity.field_70170_p.func_217376_c((Entity)snowman);
    }

    public boolean func_75253_b() {
        return this.ticksLeft > 0;
    }

    public boolean func_75250_a() {
        if (this.entity.isTamed() && this.entity.getOwner() == null) {
            this.entity.unableToFollow();
            return false;
        }
        return this.entity.isTamed() && this.entity.field_70170_p.field_73012_v.nextFloat() < 0.002f && this.noSnowManNearby() && QuestData.get((ServerPlayerEntity)Objects.requireNonNull(this.entity.getOwner())).getAlignment() == this.entity.alignment;
    }

    private boolean noSnowManNearby() {
        return this.entity.field_70170_p.func_217374_a(SnowGolemEntity.class, TARGETING, (LivingEntity)this.entity, this.entity.func_174813_aQ().func_186662_g(8.0)).isEmpty();
    }
}

