/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.entity.base.PixieEntity;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.sound.ModSoundEvents;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.server.ServerWorld;

public class TargetBreedGoal
extends Goal {
    private static final EntityPredicate TARGETING = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c();
    private final PixieEntity entity;
    private AnimalEntity targetAnimal;
    private AnimalEntity partner;
    private int ticksLeft = 0;

    public TargetBreedGoal(PixieEntity entity) {
        this.entity = entity;
    }

    public void func_75246_d() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.targetAnimal == null || this.partner == null || !this.targetAnimal.func_70089_S() || !this.partner.func_70089_S()) {
                this.targetAnimal = this.findTarget();
                this.partner = this.findPartner();
                if (this.targetAnimal == null || this.partner == null || !this.targetAnimal.func_70089_S() || !this.partner.func_70089_S()) {
                    this.reset();
                    return;
                }
            }
            if (!this.targetAnimal.func_70089_S() || !this.partner.func_70089_S() || this.targetAnimal.func_70874_b() != 0 || this.partner.func_70874_b() != 0) {
                this.reset();
                return;
            }
            if (this.ticksLeft <= 0) {
                if (this.entity.field_70170_p instanceof ServerWorld) {
                    this.targetAnimal.func_234177_a_((ServerWorld)this.entity.field_70170_p, this.partner);
                    FeywildMod.getNetwork().sendParticles(this.entity.field_70170_p, ParticleSerializer.Type.ANIMAL_BREED, this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_(), this.targetAnimal.func_226277_ct_(), this.targetAnimal.func_226278_cu_(), this.targetAnimal.func_226281_cx_());
                }
                this.reset();
            } else if (this.ticksLeft == 110) {
                this.spellCasting();
            } else if (this.ticksLeft <= 100) {
                this.entity.func_200602_a(EntityAnchorArgument.Type.EYES, this.targetAnimal.func_213303_ch());
                this.entity.func_70661_as().func_75497_a((Entity)this.targetAnimal, 0.5);
            }
        }
    }

    public void func_75249_e() {
        this.ticksLeft = 120;
        this.targetAnimal = null;
        this.partner = null;
    }

    private void spellCasting() {
        this.entity.setCasting(true);
        this.entity.func_184185_a(ModSoundEvents.pixieSpellcasting, 1.0f, 1.0f);
    }

    protected void reset() {
        this.entity.setCasting(false);
        this.targetAnimal = null;
        this.partner = null;
        this.ticksLeft = -1;
    }

    public boolean func_75253_b() {
        return this.ticksLeft > 0;
    }

    public boolean func_75250_a() {
        if (this.entity.isTamed() && this.entity.getOwner() == null) {
            this.entity.unableToFollow();
            return false;
        }
        return this.entity.isTamed() && this.entity.field_70170_p.field_73012_v.nextFloat() < 0.01f && QuestData.get((ServerPlayerEntity)Objects.requireNonNull(this.entity.getOwner())).getAlignment() == this.entity.alignment;
    }

    @Nullable
    private AnimalEntity findTarget() {
        double distance = Double.MAX_VALUE;
        AnimalEntity current = null;
        for (AnimalEntity animal : this.entity.field_70170_p.func_217374_a(AnimalEntity.class, TARGETING, (LivingEntity)this.entity, this.entity.func_174813_aQ().func_186662_g(8.0))) {
            if (animal.func_70874_b() != 0 || !(this.entity.func_70068_e((Entity)animal) < distance)) continue;
            current = animal;
            distance = this.entity.func_70068_e((Entity)animal);
        }
        return current;
    }

    @Nullable
    private AnimalEntity findPartner() {
        if (this.targetAnimal != null) {
            double distance = Double.MAX_VALUE;
            AnimalEntity current = null;
            for (AnimalEntity animal : this.targetAnimal.field_70170_p.func_217374_a(AnimalEntity.class, TARGETING, (LivingEntity)this.targetAnimal, this.targetAnimal.func_174813_aQ().func_186662_g(8.0))) {
                if (animal.func_70874_b() != 0) continue;
                int oldInLove1 = this.targetAnimal.func_234178_eO_();
                int oldInLove2 = animal.func_234178_eO_();
                this.targetAnimal.func_204700_e(1);
                animal.func_204700_e(1);
                if (this.targetAnimal.func_70878_b(animal) && this.targetAnimal.func_70068_e((Entity)animal) < distance) {
                    current = animal;
                    distance = this.targetAnimal.func_70068_e((Entity)animal);
                }
                this.targetAnimal.func_204700_e(oldInLove1);
                animal.func_204700_e(oldInLove2);
            }
            return current;
        }
        return null;
    }
}

