/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.item;

import com.feywild.feywild.entity.DwarfBlacksmithEntity;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.item.SummoningScrollDwarfBlacksmith;
import com.feywild.feywild.item.SummoningScrollFey;
import com.feywild.feywild.item.TooltipItem;
import com.feywild.feywild.util.TooltipHelper;
import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SummoningScroll<T extends LivingEntity>
extends TooltipItem {
    private static final Set<String> STORE_TAG_BLACKLIST = ImmutableSet.of((Object)"id", (Object)"Pos", (Object)"Motion", (Object)"Rotation", (Object)"FallDistance", (Object)"Fire", (Object[])new String[]{"Air", "OnGround", "UUID", "CustomName", "CustomNameVisible", "Passengers", "SummonPos"});
    private static final Map<EntityType<?>, SummoningScroll<?>> CAPTURE_MAP = Collections.synchronizedMap(new HashMap());
    protected final EntityType<T> type;
    @Nullable
    private final SoundEvent soundEvent;

    public SummoningScroll(ModX mod, EntityType<T> type, @Nullable SoundEvent soundEvent, Item.Properties properties) {
        super(mod, properties, new ITextComponent[0]);
        this.type = type;
        this.soundEvent = soundEvent;
    }

    public static <T extends LivingEntity> void registerCapture(EntityType<? extends T> type, SummoningScroll<T> scroll) {
        CAPTURE_MAP.put(type, scroll);
    }

    protected boolean canSummon(World world, PlayerEntity player, BlockPos pos, @Nullable CompoundNBT storedTag, T entity) {
        return true;
    }

    protected boolean canCapture(World world, PlayerEntity player, T entity) {
        return true;
    }

    protected void prepareEntity(World world, PlayerEntity player, BlockPos pos, T entity) {
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        if (this.type != null) {
            CompoundNBT storedTag = null;
            if (context.func_195996_i().func_77942_o() && context.func_195996_i().func_196082_o().func_150297_b("StoredEntityData", 10)) {
                storedTag = context.func_195996_i().func_196082_o().func_74775_l("StoredEntityData");
            }
            if (context.func_195999_j() != null) {
                if (!context.func_195991_k().field_72995_K) {
                    LivingEntity entity = (LivingEntity)this.type.func_200721_a(context.func_195991_k());
                    if (entity != null && this.canSummon(context.func_195991_k(), context.func_195999_j(), context.func_195995_a().func_185334_h(), storedTag, entity)) {
                        if (storedTag != null) {
                            entity.func_70020_e(storedTag);
                        }
                        if (context.func_195996_i().func_82837_s()) {
                            entity.func_200203_b(context.func_195996_i().func_200301_q());
                        }
                        BlockPos offsetPos = context.func_195995_a().func_177972_a(context.func_196000_l());
                        entity.func_70107_b((double)offsetPos.func_177958_n() + 0.5, (double)offsetPos.func_177956_o(), (double)offsetPos.func_177952_p() + 0.5);
                        this.prepareEntity(context.func_195991_k(), context.func_195999_j(), context.func_195995_a().func_185334_h(), entity);
                        if (this instanceof SummoningScrollFey || this instanceof SummoningScrollDwarfBlacksmith) {
                            context.func_195991_k().func_217376_c((Entity)entity);
                            if (this.soundEvent != null) {
                                entity.func_184185_a(this.soundEvent, 1.0f, 1.0f);
                            }
                        }
                        if (!context.func_195999_j().func_184812_l_()) {
                            context.func_195996_i().func_190918_g(1);
                            if (!(entity instanceof DwarfBlacksmithEntity)) {
                                context.func_195999_j().func_191521_c(new ItemStack((IItemProvider)ModItems.summoningScroll));
                            }
                        }
                    } else {
                        context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild.summon_fail"), context.func_195999_j().func_110124_au());
                    }
                }
                return ActionResultType.func_233537_a_((boolean)context.func_195991_k().field_72995_K);
            }
        }
        return ActionResultType.PASS;
    }

    public boolean onLeftClickEntity(ItemStack oldStack, PlayerEntity player, Entity entity) {
        if (this.type == null) {
            EntityType type = entity.func_200600_R();
            if (entity instanceof LivingEntity && CAPTURE_MAP.containsKey(type)) {
                SummoningScroll<?> scroll = CAPTURE_MAP.get(type);
                if (!entity.field_70170_p.field_72995_K && scroll.canCapture(entity.field_70170_p, player, (LivingEntity)entity)) {
                    if (entity.func_184218_aH()) {
                        entity.func_184210_p();
                    }
                    entity.func_184188_bt().forEach(Entity::func_184210_p);
                    ItemStack stack = new ItemStack(scroll);
                    CompoundNBT storedData = entity.func_189511_e(new CompoundNBT());
                    STORE_TAG_BLACKLIST.forEach(arg_0 -> ((CompoundNBT)storedData).func_82580_o(arg_0));
                    stack.func_196082_o().func_218657_a("StoredEntityData", (INBT)storedData);
                    if (entity.func_145818_k_()) {
                        stack.func_200302_a(entity.func_200201_e());
                    }
                    if (!player.func_184812_l_()) {
                        oldStack.func_190918_g(1);
                    }
                    if (PlayerInventory.func_184435_e((int)player.field_71071_by.field_70461_c) && player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c).func_190926_b()) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                    } else if (!player.field_71071_by.func_70441_a(stack)) {
                        ItemEntity ie = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack.func_77946_l());
                        ie.func_200217_b(player.func_110124_au());
                        entity.field_70170_p.func_217376_c((Entity)ie);
                    }
                    player.func_184609_a(Hand.MAIN_HAND);
                    entity.func_70106_y();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        TooltipHelper.addTooltip(tooltip, new ITextComponent[]{new TranslationTextComponent("message.feywild.summoning_scroll")});
    }
}

