/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.jei;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.trade.recipe.TradeRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TradeRecipeCategory
implements IRecipeCategory<TradeRecipe> {
    public static final ResourceLocation UID = new ResourceLocation(FeywildMod.getInstance().modid, "trades");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable rightArrow;

    public TradeRecipeCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(178, 192);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.marketRuneStone));
        this.slot = helper.getSlotDrawable();
        this.rightArrow = helper.createDrawable(new ResourceLocation("minecraft", "textures/gui/container/furnace.png"), 176, 14, 24, 16);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends TradeRecipe> getRecipeClass() {
        return TradeRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.trades.title", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull TradeRecipe recipe, @Nonnull IIngredients ii) {
        ImmutableList.Builder packedInputs = ImmutableList.builder();
        ImmutableList.Builder packedOutputs = ImmutableList.builder();
        for (TradeRecipe.Entry entry : recipe.trades) {
            packedInputs.add(entry.input);
            packedInputs.add(entry.additional);
            packedOutputs.add(entry.output);
        }
        ii.setInputLists(VanillaTypes.ITEM, (List)packedInputs.build());
        ii.setOutputLists(VanillaTypes.ITEM, (List)packedOutputs.build());
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull TradeRecipe recipe, @Nonnull IIngredients ii) {
        for (int i = 0; i < recipe.trades.size(); ++i) {
            int xOff = recipe.trades.size() <= 8 ? 42 : i / 8 * 93;
            int yOff = 26 + 20 * (i % 8);
            layout.getItemStacks().init(3 * i, true, xOff + 1, yOff);
            layout.getItemStacks().init(3 * i + 1, true, xOff + 21, yOff);
            layout.getItemStacks().init(3 * i + 2, false, xOff + 67, yOff);
        }
        layout.getItemStacks().set(ii);
    }

    public void draw(@Nonnull TradeRecipe recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int textX = 89 - font.func_78256_a(recipe.id.func_110623_a()) / 2;
        font.func_238405_a_(matrixStack, this.getText(recipe.id.func_110623_a()), (float)textX, 3.0f, 0xFFFFFF);
        TranslationTextComponent levelText = new TranslationTextComponent("jei.trades.level", new Object[]{recipe.level});
        font.func_243246_a(matrixStack, (ITextComponent)levelText, (float)textX, 14.0f, 0xFFFFFF);
        for (int i = 0; i < recipe.trades.size(); ++i) {
            int xOff = recipe.trades.size() <= 8 ? 42 : i / 8 * 93;
            int yOff = 26 + 20 * (i % 8);
            this.slot.draw(matrixStack, xOff + 1, yOff);
            this.slot.draw(matrixStack, xOff + 21, yOff);
            this.slot.draw(matrixStack, xOff + 67, yOff);
            this.rightArrow.draw(matrixStack, xOff + 41, yOff + 1);
        }
    }

    public String getText(String text) {
        return text.replace("_", " ").replace("/trades", " ");
    }
}

