/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.network;

import com.feywild.feywild.trade.recipe.TradeRecipe;
import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class TradesSerializer
implements PacketSerializer<Message> {
    public Class<Message> messageClass() {
        return Message.class;
    }

    public void encode(Message msg, PacketBuffer buffer) {
        buffer.func_150787_b(msg.recipes.size());
        msg.recipes.forEach(recipe -> {
            buffer.func_192572_a(recipe.id);
            buffer.func_150787_b(recipe.level);
            buffer.func_150787_b(recipe.trades.size());
            recipe.trades.forEach(trade -> {
                buffer.func_150787_b(trade.input.size());
                trade.input.forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
                buffer.func_150787_b(trade.additional.size());
                trade.additional.forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
                buffer.func_150787_b(trade.output.size());
                trade.output.forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
            });
        });
    }

    public Message decode(PacketBuffer buffer) {
        ImmutableList.Builder recipes = ImmutableList.builder();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.func_192575_l();
            int level = buffer.func_150792_a();
            ImmutableList.Builder trades = ImmutableList.builder();
            int tradeSize = buffer.func_150792_a();
            for (int j = 0; j < tradeSize; ++j) {
                trades.add((Object)new TradeRecipe.Entry(this.readStackList(buffer), this.readStackList(buffer), this.readStackList(buffer)));
            }
            recipes.add((Object)new TradeRecipe(id, level, (List<TradeRecipe.Entry>)trades.build()));
        }
        return new Message((List<TradeRecipe>)recipes.build());
    }

    private List<ItemStack> readStackList(PacketBuffer buffer) {
        ImmutableList.Builder stacks = ImmutableList.builder();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            stacks.add((Object)buffer.func_150791_c());
        }
        return stacks.build();
    }

    public static class Message {
        public final List<TradeRecipe> recipes;

        public Message(List<TradeRecipe> recipes) {
            this.recipes = recipes;
        }
    }
}

