/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest.player;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.compat.MineMentionCompat;
import com.feywild.feywild.events.QuestCompletionEvent;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.Quest;
import com.feywild.feywild.quest.QuestDisplay;
import com.feywild.feywild.quest.QuestLine;
import com.feywild.feywild.quest.QuestManager;
import com.feywild.feywild.quest.QuestReward;
import com.feywild.feywild.quest.player.CapabilityQuests;
import com.feywild.feywild.quest.player.QuestProgress;
import com.feywild.feywild.quest.task.TaskType;
import com.feywild.feywild.quest.util.SelectableQuest;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;

public class QuestData {
    private final List<ResourceLocation> pendingCompletion = new ArrayList<ResourceLocation>();
    private final Set<ResourceLocation> completedQuests = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, QuestProgress> activeQuests = new HashMap<ResourceLocation, QuestProgress>();
    @Nullable
    private ServerPlayerEntity player;
    @Nullable
    private Alignment alignment;
    @Nullable
    private Alignment pendingAlignment;
    private int reputation;

    public static QuestData get(ServerPlayerEntity player) {
        return (QuestData)player.getCapability(CapabilityQuests.QUESTS).orElseGet(() -> {
            FeywildMod.getInstance().logger.warn("Quest Data capability not present on player: " + player);
            return new QuestData();
        });
    }

    public void attach(ServerPlayerEntity player) {
        this.player = player;
        this.startNextQuests();
    }

    public boolean canComplete(Alignment alignment) {
        return this.alignment == alignment;
    }

    @Nullable
    public QuestDisplay initialize(Alignment alignment) {
        if (this.alignment == null) {
            Quest rootQuest;
            QuestLine quests = QuestManager.getQuests(alignment);
            Quest quest = rootQuest = quests == null ? null : quests.getQuest(new ResourceLocation(FeywildMod.getInstance().modid, "root"));
            if (rootQuest != null) {
                this.pendingAlignment = alignment;
                return rootQuest.start;
            }
            return null;
        }
        return null;
    }

    public void acceptAlignment() {
        if (this.pendingAlignment != null && this.alignment == null && this.player != null) {
            Quest rootQuest;
            this.alignment = this.pendingAlignment;
            this.pendingAlignment = null;
            this.reputation = 0;
            this.pendingCompletion.clear();
            this.completedQuests.clear();
            this.activeQuests.clear();
            QuestLine quests = QuestManager.getQuests(this.alignment);
            Quest quest = rootQuest = quests == null ? null : quests.getQuest(new ResourceLocation(FeywildMod.getInstance().modid, "root"));
            if (rootQuest != null && rootQuest.tasks.isEmpty()) {
                for (QuestReward reward : rootQuest.rewards) {
                    reward.grantReward(this.player);
                }
                this.reputation += rootQuest.reputation;
                this.completedQuests.add(rootQuest.id);
            }
            this.startNextQuests();
            if (ModList.get().isLoaded("minemention")) {
                MineMentionCompat.availabilityChange(this.player);
            }
        }
    }

    public void denyAlignment() {
        this.pendingAlignment = null;
    }

    public boolean reset() {
        Alignment oldAlignment = this.alignment;
        this.alignment = null;
        this.reputation = 0;
        this.pendingCompletion.clear();
        this.completedQuests.clear();
        this.activeQuests.clear();
        if (ModList.get().isLoaded("minemention")) {
            MineMentionCompat.availabilityChange(this.player);
        }
        return oldAlignment != null;
    }

    @Nullable
    public QuestLine getQuestLine() {
        return this.alignment == null ? null : QuestManager.getQuests(this.alignment);
    }

    public int getReputation() {
        return this.alignment == null ? 0 : this.reputation;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.alignment;
    }

    public boolean checkReputation(Alignment alignment, int min_reputation) {
        return this.alignment == alignment && this.reputation > min_reputation;
    }

    @Nullable
    public QuestDisplay getActiveQuestDisplay(ResourceLocation id) {
        QuestLine quests = this.getQuestLine();
        if (quests != null && this.player != null && this.activeQuests.containsKey(id)) {
            Quest quest = quests.getQuest(id);
            if (quest != null) {
                return quest.start;
            }
            return null;
        }
        return null;
    }

    public List<SelectableQuest> getActiveQuests() {
        QuestLine quests = this.getQuestLine();
        if (quests != null && this.player != null) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (QuestProgress progress : this.activeQuests.values().stream().sorted(Comparator.comparing(q -> q.quest)).collect(Collectors.toList())) {
                Quest quest = quests.getQuest(progress.quest);
                if (quest == null) continue;
                list.add((Object)new SelectableQuest(quest.id, quest.icon, quest.start));
            }
            return list.build();
        }
        return ImmutableList.of();
    }

    @Nullable
    public QuestDisplay completePendingQuest() {
        QuestLine quests = this.getQuestLine();
        if (quests != null && this.player != null && !this.pendingCompletion.isEmpty()) {
            while (!this.pendingCompletion.isEmpty()) {
                ResourceLocation id = this.pendingCompletion.remove(0);
                QuestDisplay display = this.tryComplete(this.player, quests, id);
                if (display == null) continue;
                return display;
            }
        }
        return null;
    }

    @Nullable
    private QuestDisplay tryComplete(ServerPlayerEntity player, QuestLine quests, ResourceLocation id) {
        Quest quest = quests.getQuest(id);
        if (quest != null) {
            QuestDisplay display;
            QuestDisplay questDisplay = display = quest.tasks.isEmpty() ? quest.start : quest.complete;
            if (display != null) {
                for (QuestReward reward : quest.rewards) {
                    reward.grantReward(player);
                }
                this.reputation += quest.reputation;
                MinecraftForge.EVENT_BUS.post((Event)new QuestCompletionEvent(this.player, quest, this.reputation));
                return display;
            }
            return null;
        }
        return null;
    }

    public boolean hasCompleted(Quest quest) {
        return this.completedQuests.contains(quest.id);
    }

    public <T> boolean checkComplete(TaskType<?, T> type, T element) {
        boolean success = false;
        QuestLine quests = this.getQuestLine();
        if (quests != null && this.player != null) {
            String msgToDisplay = null;
            for (QuestProgress progress : this.activeQuests.values()) {
                String progressMsg = progress.checkComplete(this.player, quests, type, element);
                if (progressMsg == null) continue;
                success = true;
                if (msgToDisplay != null) continue;
                msgToDisplay = progressMsg;
            }
            if (success) {
                boolean shouldNotify = false;
                Iterator<QuestProgress> itr = this.activeQuests.values().iterator();
                while (itr.hasNext()) {
                    QuestProgress progress = itr.next();
                    if (!progress.shouldBeComplete(quests)) continue;
                    this.pendingCompletion.add(progress.quest);
                    this.completedQuests.add(progress.quest);
                    shouldNotify = true;
                    itr.remove();
                }
                if (shouldNotify) {
                    this.player.func_146105_b((ITextComponent)new TranslationTextComponent("message.feywild.quest_completion"), true);
                } else {
                    this.player.func_146105_b((ITextComponent)new StringTextComponent(msgToDisplay), true);
                }
                this.startNextQuests();
            }
        }
        return success;
    }

    public void startNextQuests() {
        QuestLine quests = this.getQuestLine();
        boolean hasEmptyQuests = false;
        if (quests != null) {
            for (Quest newQuest : quests.getNextQuests(this.activeQuests.keySet(), this.completedQuests)) {
                if (newQuest.tasks.isEmpty()) {
                    if (this.pendingCompletion.contains(newQuest.id)) continue;
                    this.pendingCompletion.add(newQuest.id);
                    this.completedQuests.add(newQuest.id);
                    hasEmptyQuests = true;
                    continue;
                }
                if (this.activeQuests.containsKey(newQuest.id)) continue;
                QuestProgress progress = new QuestProgress(newQuest.id);
                this.activeQuests.put(newQuest.id, progress);
            }
        }
        if (hasEmptyQuests) {
            this.startNextQuests();
        }
    }

    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Alignment", Alignment.optionId(this.alignment));
        nbt.func_74768_a("Reputation", this.reputation);
        ListNBT pending = new ListNBT();
        for (ResourceLocation resourceLocation : this.pendingCompletion) {
            pending.add((Object)StringNBT.func_229705_a_((String)resourceLocation.toString()));
        }
        nbt.func_218657_a("Pending", (INBT)pending);
        ListNBT completed = new ListNBT();
        for (ResourceLocation quest : this.completedQuests) {
            completed.add((Object)StringNBT.func_229705_a_((String)quest.toString()));
        }
        nbt.func_218657_a("Completed", (INBT)completed);
        CompoundNBT compoundNBT = new CompoundNBT();
        for (Map.Entry<ResourceLocation, QuestProgress> entry : this.activeQuests.entrySet()) {
            compoundNBT.func_218657_a(entry.getKey().toString(), (INBT)entry.getValue().write());
        }
        nbt.func_218657_a("Active", (INBT)compoundNBT);
        return nbt;
    }

    public void read(CompoundNBT nbt) {
        this.alignment = Alignment.byOptionId(nbt.func_74779_i("Alignment"));
        this.reputation = nbt.func_74762_e("Reputation");
        ListNBT pending = nbt.func_150295_c("Pending", 8);
        this.pendingCompletion.clear();
        for (int i = 0; i < pending.size(); ++i) {
            ResourceLocation id = ResourceLocation.func_208304_a((String)pending.func_150307_f(i));
            if (id == null) continue;
            this.pendingCompletion.add(id);
        }
        ListNBT completed = nbt.func_150295_c("Completed", 8);
        this.completedQuests.clear();
        for (int i = 0; i < completed.size(); ++i) {
            ResourceLocation id = ResourceLocation.func_208304_a((String)completed.func_150307_f(i));
            if (id == null) continue;
            this.completedQuests.add(id);
        }
        CompoundNBT active = nbt.func_74775_l("Active");
        this.activeQuests.clear();
        for (String key : active.func_150296_c()) {
            ResourceLocation id = ResourceLocation.func_208304_a((String)key);
            if (id == null) continue;
            QuestProgress progress = new QuestProgress(id);
            progress.read(active.func_74775_l(key));
            this.activeQuests.put(id, progress);
        }
    }
}

