/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest.player;

import com.feywild.feywild.quest.Quest;
import com.feywild.feywild.quest.QuestLine;
import com.feywild.feywild.quest.task.TaskType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class QuestProgress {
    public final ResourceLocation quest;
    private final Map<Integer, Integer> taskProgress = new HashMap<Integer, Integer>();

    public QuestProgress(ResourceLocation quest) {
        this.quest = quest;
    }

    @Nullable
    public <T> String checkComplete(ServerPlayerEntity player, QuestLine quests, TaskType<?, T> type, T element) {
        String progressMsg = null;
        Quest quest = quests.getQuest(this.quest);
        if (quest != null) {
            for (int i = 0; i < quest.tasks.size(); ++i) {
                if (!quest.tasks.get(i).checkCompleted(player, type, element)) continue;
                this.taskProgress.putIfAbsent(i, 0);
                this.taskProgress.computeIfPresent(i, (idx, value) -> value + 1);
                if (progressMsg != null) continue;
                progressMsg = this.taskProgress.get(i) + " / " + quest.tasks.get((int)i).times;
            }
        }
        return progressMsg;
    }

    public boolean valid(QuestLine quests) {
        return quests.getQuest(this.quest) != null;
    }

    public boolean shouldBeComplete(QuestLine quests) {
        Quest quest = quests.getQuest(this.quest);
        if (quest != null) {
            for (int i = 0; i < quest.tasks.size(); ++i) {
                int completionTimes = this.taskProgress.getOrDefault(i, 0);
                if (completionTimes >= quest.tasks.get((int)i).times) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<Integer, Integer> entry : this.taskProgress.entrySet()) {
            nbt.func_74768_a(Integer.toString(entry.getKey()), entry.getValue().intValue());
        }
        return nbt;
    }

    public void read(CompoundNBT nbt) {
        this.taskProgress.clear();
        for (String key : nbt.func_150296_c()) {
            try {
                int task = Integer.parseInt(key);
                this.taskProgress.put(task, nbt.func_74762_e(key));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

