/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest.task;

import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.task.TaskType;
import com.feywild.feywild.quest.util.AlignmentStack;
import com.feywild.feywild.quest.util.FeyGift;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class FeyGiftTask
implements TaskType<FeyGift, AlignmentStack> {
    public static final FeyGiftTask INSTANCE = new FeyGiftTask();

    private FeyGiftTask() {
    }

    @Override
    public Class<FeyGift> element() {
        return FeyGift.class;
    }

    @Override
    public Class<AlignmentStack> testType() {
        return AlignmentStack.class;
    }

    @Override
    public boolean checkCompleted(ServerPlayerEntity player, FeyGift element, AlignmentStack match) {
        return element.alignment == match.alignment && element.ingredient.test(match.getStack());
    }

    @Override
    public FeyGift fromJson(JsonObject json) {
        Alignment alignment = Alignment.byId(json.get("alignment").getAsString());
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get("item"));
        return new FeyGift(alignment, ingredient);
    }

    @Override
    public JsonObject toJson(FeyGift element) {
        JsonObject json = new JsonObject();
        json.addProperty("alignment", element.alignment.id);
        json.add("item", element.ingredient.func_200304_c());
        return json;
    }

    @Override
    @Nullable
    public Item icon(FeyGift element) {
        ItemStack[] matching = element.ingredient.func_193365_a();
        if (matching.length == 1 && !matching[0].func_190926_b()) {
            return matching[0].func_77973_b();
        }
        return null;
    }
}

