/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest.task;

import com.feywild.feywild.quest.task.TaskType;
import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RegistryTaskType<T extends IForgeRegistryEntry<T>, X>
implements TaskType<T, X> {
    private final String key;
    private final IForgeRegistry<T> registry;

    protected RegistryTaskType(String key, IForgeRegistry<T> registry) {
        this.key = key;
        this.registry = registry;
    }

    @Override
    public Class<T> element() {
        return this.registry.getRegistrySuperType();
    }

    @Override
    public T fromJson(JsonObject json) {
        IForgeRegistryEntry value;
        ResourceLocation rl = ResourceLocation.func_208304_a((String)json.get(this.key).getAsString());
        IForgeRegistryEntry iForgeRegistryEntry = value = rl == null ? null : this.registry.getValue(rl);
        if (value == null) {
            throw new IllegalStateException("Can't load feywild quest task: " + this.element().getSimpleName() + " not found: " + rl);
        }
        return (T)value;
    }

    @Override
    public JsonObject toJson(T element) {
        JsonObject json = new JsonObject();
        ResourceLocation rl = this.registry.getKey(element);
        if (rl == null) {
            throw new IllegalStateException(this.element().getSimpleName() + " not registered: " + element);
        }
        json.addProperty(this.key, rl.toString());
        return json;
    }
}

