/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.recipes;

import com.feywild.feywild.recipes.IAltarRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.feywild.feywild.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AltarRecipe
implements IAltarRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final List<Ingredient> inputs;
    private final NonNullList<Ingredient> inputList;

    public AltarRecipe(ResourceLocation id, ItemStack output, List<Ingredient> inputs) {
        this.id = id;
        this.output = output;
        this.inputs = ImmutableList.copyOf(inputs);
        this.inputList = NonNullList.func_191197_a((int)this.inputs.size(), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputList.set(i, (Object)this.inputs.get(i));
        }
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.ALTAR_SERIALIZER;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputList;
    }

    @Override
    public Optional<ItemStack> getResult(List<ItemStack> inputs) {
        return Util.simpleMatch(this.inputs, inputs) ? Optional.of(this.func_77571_b()) : Optional.empty();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AltarRecipe> {
        @Nonnull
        public AltarRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (JsonElement jsonElement : ingredients) {
                inputs.add((Object)Ingredient.func_199802_a((JsonElement)jsonElement));
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
            return new AltarRecipe(recipeId, output, (List<Ingredient>)inputs.build());
        }

        @Nullable
        public AltarRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            int inputSize = buffer.func_150792_a();
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (int i = 0; i < inputSize; ++i) {
                inputs.add((Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            return new AltarRecipe(recipeId, output, (List<Ingredient>)inputs.build());
        }

        public void toNetwork(PacketBuffer buffer, AltarRecipe recipe) {
            buffer.func_150787_b(recipe.func_192400_c().size());
            recipe.inputs.forEach(i -> i.func_199564_a(buffer));
            buffer.writeItemStack(recipe.func_77571_b(), false);
        }
    }
}

