/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.trade;

import com.feywild.feywild.trade.TradeLevelData;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.item.MerchantOffers;
import net.minecraft.util.ResourceLocation;

public class TradeData {
    public static final TradeData EMPTY = new TradeData((List<TradeLevelData>)ImmutableList.of());
    private final List<TradeLevelData> levels;

    public TradeData(List<TradeLevelData> levels) {
        this.levels = ImmutableList.copyOf(levels);
    }

    public int getMaxLevel() {
        return this.levels.size();
    }

    public TradeLevelData getLevel(int level) {
        return this.levels.get(level - 1);
    }

    public VillagerData initialize(Entity merchant, VillagerData data, MerchantOffers offers, Random random) {
        if (this.getMaxLevel() >= 1) {
            this.getLevel(1).applyTo(merchant, offers, random);
            return new VillagerData(data.func_221129_a(), data.func_221130_b(), 1);
        }
        return data;
    }

    public VillagerData levelUp(Entity merchant, VillagerData data, MerchantOffers offers, Random random) {
        if (data.func_221132_c() < this.getMaxLevel()) {
            this.getLevel(data.func_221132_c() + 1).applyTo(merchant, offers, random);
            return new VillagerData(data.func_221129_a(), data.func_221130_b(), data.func_221132_c() + 1);
        }
        return data;
    }

    public static TradeData fromJson(ResourceLocation id, JsonElement data) {
        ImmutableList.Builder levels = ImmutableList.builder();
        for (JsonElement elem : data.getAsJsonArray()) {
            levels.add((Object)TradeLevelData.fromJson(elem.getAsJsonObject()));
        }
        return new TradeData((List<TradeLevelData>)levels.build());
    }
}

