/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.trade;

import com.feywild.feywild.trade.TradeData;
import com.feywild.feywild.trade.recipe.TradeRecipe;
import com.feywild.feywild.trade.recipe.TradeRecipeManager;
import com.feywild.feywild.util.DatapackHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class TradeManager {
    private static Map<ResourceLocation, TradeData> trades = ImmutableMap.of();
    private static List<TradeRecipe> cachedRecipes = null;

    public static TradeData getTrades(EntityType<?> type, String category) {
        if (type.getRegistryName() == null) {
            return TradeData.EMPTY;
        }
        ResourceLocation entityId = type.getRegistryName();
        ResourceLocation id = new ResourceLocation(entityId.func_110624_b(), entityId.func_110623_a() + "/" + category);
        return trades.getOrDefault(id, TradeData.EMPTY);
    }

    public static List<TradeRecipe> buildRecipes() {
        if (cachedRecipes == null) {
            ImmutableList.Builder recipes = ImmutableList.builder();
            for (Map.Entry<ResourceLocation, TradeData> entry : trades.entrySet()) {
                recipes.addAll(TradeRecipeManager.getRecipes(entry.getKey(), entry.getValue()));
            }
            cachedRecipes = recipes.build();
        }
        return cachedRecipes;
    }

    public static IFutureReloadListener createReloadListener() {
        return new ReloadListener<Void>(){

            @Nonnull
            protected Void prepare(@Nonnull IResourceManager rm, @Nonnull IProfiler profiler) {
                return null;
            }

            protected void apply(@Nonnull Void value, @Nonnull IResourceManager rm, @Nonnull IProfiler profiler) {
                trades = DatapackHelper.loadData(rm, "feywild_trades", TradeData::fromJson);
                cachedRecipes = null;
            }
        };
    }
}

