/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.util;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextProcessor {
    private static final Pattern CONTROL_PATTERN = Pattern.compile("\\$\\(((?:(?:\\w+|#[0-9A-Fa-f]{6})(?:;(?:\\w+|#[0-9A-Fa-f]{6}))*)?)\\)");

    public static List<ITextComponent> process(ITextComponent text) {
        return TextProcessor.process(text.getString());
    }

    public static List<ITextComponent> process(String text) {
        return (List)Arrays.stream(text.split("\\$\\((?:n|newline)\\)")).map(String::trim).map(TextProcessor::processLine).collect(ImmutableList.toImmutableList());
    }

    public static ITextComponent processLine(ITextComponent line) {
        return TextProcessor.processLine(line.getString());
    }

    public static ITextComponent processLine(String line) {
        if (line.isEmpty()) {
            return new StringTextComponent("");
        }
        Matcher m = CONTROL_PATTERN.matcher(line);
        StringTextComponent tc = new StringTextComponent("");
        int idx = 0;
        Style style = Style.field_240709_b_;
        while (m.find()) {
            if (idx < m.start()) {
                tc.func_230529_a_((ITextComponent)new StringTextComponent(line.substring(idx, m.start())).func_240703_c_(style));
            }
            idx = m.end();
            String cmd = m.group(1).trim();
            if (cmd.isEmpty()) {
                style = Style.field_240709_b_;
                continue;
            }
            for (String part : cmd.split(";")) {
                if (part.startsWith("#")) {
                    try {
                        int color = Integer.parseInt(part.substring(1), 16);
                        style = style.func_240718_a_(Color.func_240743_a_((int)color));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("b".equalsIgnoreCase(part.trim()) || "bold".equalsIgnoreCase(part.trim())) {
                    style = style.func_240713_a_(Boolean.valueOf(true));
                    continue;
                }
                if ("i".equalsIgnoreCase(part.trim()) || "italic".equalsIgnoreCase(part.trim())) {
                    style = style.func_240722_b_(Boolean.valueOf(true));
                    continue;
                }
                if ("u".equalsIgnoreCase(part.trim()) || "underline".equalsIgnoreCase(part.trim())) {
                    style = style.func_244282_c(Boolean.valueOf(true));
                    continue;
                }
                if ("s".equalsIgnoreCase(part.trim()) || "strikethrough".equalsIgnoreCase(part.trim())) {
                    style = style.setStrikethrough(Boolean.valueOf(true));
                    continue;
                }
                if ("spring".equalsIgnoreCase(part.trim())) {
                    style = style.func_240718_a_(Color.func_240743_a_((int)0x66CC99));
                    continue;
                }
                if ("summer".equalsIgnoreCase(part.trim())) {
                    style = style.func_240718_a_(Color.func_240743_a_((int)0xFFCC00));
                    continue;
                }
                if ("autumn".equalsIgnoreCase(part.trim())) {
                    style = style.func_240718_a_(Color.func_240743_a_((int)0xCC3333));
                    continue;
                }
                if ("winter".equalsIgnoreCase(part.trim())) {
                    style = style.func_240718_a_(Color.func_240743_a_((int)0x66CCFF));
                    continue;
                }
                for (TextFormatting tf : TextFormatting.values()) {
                    if (!tf.func_96297_d().equalsIgnoreCase(part.trim())) continue;
                    style = style.func_240712_a_(tf);
                }
            }
        }
        if (idx < line.length()) {
            tc.func_230529_a_((ITextComponent)new StringTextComponent(line.substring(idx)).func_240703_c_(style));
        }
        return tc;
    }
}

