/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.biome.biomes;

import com.feywild.feywild.config.MobConfig;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.world.biome.ModConfiguredSurfaceBuilders;
import com.feywild.feywild.world.biome.biomes.BiomeType;
import com.feywild.feywild.world.structure.ModConfiguredStructures;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;

public class SpringBiome
implements BiomeType {
    public static final SpringBiome INSTANCE = new SpringBiome();

    private SpringBiome() {
    }

    @Override
    public Biome.Category category() {
        return Biome.Category.FOREST;
    }

    @Override
    public float scale() {
        return WorldGenConfig.biomes.spring.size;
    }

    @Override
    public float temperature() {
        return 0.7f;
    }

    @Override
    public float downfall() {
        return 0.8f;
    }

    @Override
    public ConfiguredSurfaceBuilder<?> surface() {
        return ModConfiguredSurfaceBuilders.SPRING_SURFACE;
    }

    @Override
    public void ambience(BiomeAmbience.Builder builder) {
        builder.func_235246_b_(4159204);
        builder.func_235248_c_(329011);
        builder.func_235239_a_(12638463);
        builder.func_242539_d(BiomeMaker.func_244206_a((float)0.7f));
        builder.func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_197632_y, 0.001f));
    }

    @Override
    public void generation(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243852_ay);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243876_bV);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243833_af);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(ModConfiguredStructures.CONFIGURED_SPRING_WORLD_TREE);
    }

    @Override
    public void spawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntityTypes.springPixie, 2 * MobConfig.spring_pixie.weight, MobConfig.spring_pixie.min, MobConfig.spring_pixie.max));
    }

    @Override
    public void overworldSpawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200764_D, 50, 1, 3));
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)builder);
    }

    @Override
    public void overworldGen(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(StructureFeatures.field_244139_e);
    }
}

