/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.gen;

import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.world.gen.FeywildOreGen;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;

public enum OreType {
    FEY_GEM_ORE(ModBlocks.feyGemBlock, ModBlocks.feyGemBlockLivingrock, WorldGenConfig.ores.fey_gem.size, WorldGenConfig.ores.fey_gem.min_height, WorldGenConfig.ores.fey_gem.max_height, WorldGenConfig.ores.fey_gem.weight);

    private final Block block;
    private final Block alfheimBlock;
    private final int maxVeinSize;
    private final int minHeight;
    private final int maxHeight;
    private final int spawnWeight;
    private final LazyValue<ConfiguredFeature<?, ?>> feature;
    private final LazyValue<ConfiguredFeature<?, ?>> alfheimFeature;

    private OreType(Block block, Block alfheimBlock, int maxVeinSize, int minHeight, int maxHeight, int spawnWeight) {
        this.block = block;
        this.alfheimBlock = alfheimBlock;
        this.maxVeinSize = maxVeinSize;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.spawnWeight = spawnWeight;
        this.feature = new LazyValue(() -> {
            OreFeatureConfig oreFeatureConfig = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, block.func_176223_P(), maxVeinSize);
            ConfiguredPlacement configuredPlacement = (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(minHeight, 0, maxHeight)).func_242728_a()).func_242731_b(spawnWeight);
            return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)Objects.requireNonNull(block.getRegistryName()), (Object)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreFeatureConfig).func_227228_a_(configuredPlacement));
        });
        this.alfheimFeature = new LazyValue(() -> {
            OreFeatureConfig oreFeatureConfig = new OreFeatureConfig(FeywildOreGen.ALFHEIM_STONE, alfheimBlock.func_176223_P(), maxVeinSize);
            ConfiguredPlacement configuredPlacement = (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(minHeight, 0, maxHeight)).func_242728_a()).func_242731_b(spawnWeight);
            return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)Objects.requireNonNull(block.getRegistryName()), (Object)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreFeatureConfig).func_227228_a_(configuredPlacement));
        });
    }

    public static OreType get(Block block) {
        for (OreType ore : OreType.values()) {
            if (block != ore.block) continue;
            return ore;
        }
        return null;
    }

    public Block getBlock() {
        return this.block;
    }

    public Block getAlfheimBlock() {
        return this.alfheimBlock;
    }

    public int getMaxVeinSize() {
        return this.maxVeinSize;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public ConfiguredFeature<?, ?> getFeature() {
        return (ConfiguredFeature)this.feature.func_179281_c();
    }

    public ConfiguredFeature<?, ?> getAlfheimFeature() {
        return (ConfiguredFeature)this.alfheimFeature.func_179281_c();
    }

    public static void setupOres() {
        for (OreType ore : OreType.values()) {
            ore.getFeature();
        }
    }
}

