/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.structure.structures;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.world.structure.structures.BaseStructure;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.Level;

public class AutumnWorldTreeStructure
extends BaseStructure {
    public static final int SEED_MODIFIER = 890124567;
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_CREATURES = ImmutableList.of((Object)new MobSpawnInfo.Spawners(ModEntityTypes.autumnPixie, 100, 4, 4));
    private static final String MESSAGE_LOCATION = "Autumn World Tree at: ";
    private static final String MESSAGE_POOL = "autumn_world_tree/start_pool";

    @Override
    public int getAverageDistanceBetweenChunks() {
        return WorldGenConfig.structures.autumn_world_tree.average_distance;
    }

    @Override
    public int getMinDistanceBetweenChunks() {
        return WorldGenConfig.structures.autumn_world_tree.minimum_distance;
    }

    @Override
    public int getSeedModifier() {
        return 890124567;
    }

    @Override
    @Nonnull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return STRUCTURE_CREATURES;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(@Nonnull DynamicRegistries dynamicRegistryManager, @Nonnull ChunkGenerator chunkGenerator, @Nonnull TemplateManager templateManagerIn, int chunkX, int chunkZ, @Nonnull Biome biomeIn, @Nonnull NoFeatureConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            BlockPos blockpos = new BlockPos(x, 0, z);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation(FeywildMod.getInstance().modid, AutumnWorldTreeStructure.MESSAGE_POOL)), 10), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)true);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 1, 0));
            this.field_75075_a.forEach(piece -> --piece.func_74874_b().field_78894_e);
            this.func_202500_a();
            FeywildMod.getInstance().logger.log(Level.DEBUG, AutumnWorldTreeStructure.MESSAGE_LOCATION + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a + " " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78895_b + " " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }
    }
}

