/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class JsonToTextComponent {
    private static final HoverEvent COPY_JSON = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("libx.misc.copy_json"));

    public static IFormattableTextComponent toText(JsonElement element) {
        Style copyTag = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, element.toString())).func_240716_a_(COPY_JSON);
        return JsonToTextComponent.toTextInternal(element).func_240703_c_(copyTag);
    }

    private static IFormattableTextComponent toTextInternal(JsonElement element) {
        if (element.isJsonNull()) {
            return new StringTextComponent("");
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return new StringTextComponent(primitive.getAsBoolean() ? "true" : "false").func_240699_a_(TextFormatting.GOLD);
            }
            if (primitive.isNumber()) {
                return new StringTextComponent(primitive.getAsNumber().toString()).func_240699_a_(TextFormatting.GOLD);
            }
            if (primitive.isString()) {
                return new StringTextComponent("\"").func_230529_a_((ITextComponent)new StringTextComponent(JsonToTextComponent.escape(primitive.getAsString())).func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent("\""));
            }
            return JsonToTextComponent.toTextInternal((JsonElement)primitive);
        }
        if (element.isJsonArray()) {
            StringTextComponent tc = new StringTextComponent("[");
            boolean first = true;
            for (JsonElement entry : element.getAsJsonArray()) {
                if (first) {
                    first = false;
                } else {
                    tc.func_230529_a_((ITextComponent)new StringTextComponent(", "));
                }
                tc = tc.func_230529_a_((ITextComponent)JsonToTextComponent.toTextInternal(entry));
            }
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("]"));
            return tc;
        }
        if (element.isJsonObject()) {
            StringTextComponent tc = new StringTextComponent("{");
            boolean first = true;
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    tc.func_230529_a_((ITextComponent)new StringTextComponent(", "));
                }
                tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("\"").func_230529_a_((ITextComponent)new StringTextComponent((String)entry.getKey()).func_240699_a_(TextFormatting.AQUA)).func_230529_a_((ITextComponent)new StringTextComponent("\""))).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)JsonToTextComponent.toTextInternal((JsonElement)entry.getValue()));
            }
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("}"));
            return tc;
        }
        throw new IllegalArgumentException("JSON type unknown: " + element.getClass());
    }

    private static String escape(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\\n").replace("\t", "\\\t").replace("\r", "\\\r").replace("\u0000", "\\\u0000").replace("\f", "\\\f");
    }
}

