/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild;

import com.feywild.feywild.FeyPlayerData;
import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.config.ClientConfig;
import com.feywild.feywild.config.MiscConfig;
import com.feywild.feywild.config.ScrollConfig;
import com.feywild.feywild.entity.BeeKnightEntity;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.network.OpenLibraryScreenSerializer;
import com.feywild.feywild.network.OpeningScreenSerializer;
import com.feywild.feywild.network.TradesSerializer;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.quest.task.BiomeTask;
import com.feywild.feywild.quest.task.CraftTask;
import com.feywild.feywild.quest.task.ItemTask;
import com.feywild.feywild.quest.task.KillTask;
import com.feywild.feywild.quest.task.StructureTask;
import com.feywild.feywild.trade.TradeManager;
import com.feywild.feywild.util.LibraryBooks;
import com.feywild.feywild.util.MenuScreen;
import com.feywild.feywild.world.dimension.market.MarketHandler;
import com.feywild.feywild.world.structure.ModStructures;
import io.github.noeppi_noeppi.libx.event.ConfigLoadedEvent;
import io.github.noeppi_noeppi.libx.event.DatapacksReloadedEvent;
import java.util.List;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;

public class EventListener {
    @SubscribeEvent
    public void craftItem(PlayerEvent.ItemCraftedEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            QuestData.get((ServerPlayerEntity)event.getPlayer()).checkComplete(CraftTask.INSTANCE, event.getCrafting());
        }
    }

    @SubscribeEvent
    public void playerKill(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getSource().func_76346_g();
            QuestData quests = QuestData.get(player);
            quests.checkComplete(KillTask.INSTANCE, event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70173_aa % 20 == 0 && !event.player.field_70170_p.field_72995_K && event.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            QuestData quests = QuestData.get(player);
            player.field_71071_by.field_70462_a.forEach(stack -> quests.checkComplete(ItemTask.INSTANCE, stack));
            player.func_71121_q().func_242406_i(player.func_233580_cy_()).ifPresent(biome -> quests.checkComplete(BiomeTask.INSTANCE, biome.func_240901_a_()));
            quests.checkComplete(StructureTask.INSTANCE, player.func_71121_q().func_241112_a_().func_235010_a_(player.func_233580_cy_(), true, (Structure)ModStructures.library).func_214627_k().getRegistryName());
        }
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!event.getWorld().field_72995_K && event.getPlayer() instanceof ServerPlayerEntity && event.getTarget() instanceof VillagerEntity && event.getTarget().func_184216_O().contains("feywild_librarian")) {
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("librarian.feywild.initial"), event.getPlayer().func_110124_au());
            FeywildMod.getNetwork().instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new OpenLibraryScreenSerializer.Message(event.getTarget().func_145748_c_(), LibraryBooks.getLibraryBooks()));
            event.getPlayer().func_226292_a_(event.getHand(), true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            if (event.getPlayer() instanceof ServerPlayerEntity) {
                FeywildMod.getNetwork().instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new TradesSerializer.Message(TradeManager.buildRecipes()));
            }
            if (!FeyPlayerData.get(event.getPlayer()).func_74767_n("feywild_got_lexicon") && MiscConfig.initial_lexicon) {
                event.getPlayer().field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.feywildLexicon));
                FeyPlayerData.get(event.getPlayer()).func_74757_a("feywild_got_lexicon", true);
            }
            if (!FeyPlayerData.get(event.getPlayer()).func_74767_n("feywild_got_scroll") && MiscConfig.initial_scroll == ScrollConfig.LOGIN) {
                FeywildMod.getNetwork().instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new OpeningScreenSerializer.Message(LibraryBooks.getLibraryBooks().size()));
                FeyPlayerData.get(event.getPlayer()).func_74757_a("feywild_got_scroll", true);
            }
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        FeyPlayerData.copy(event.getOriginal(), event.getPlayer());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void openGui(GuiOpenEvent event) {
        if (ClientConfig.replace_menu && event.getGui() instanceof MainMenuScreen && !(event.getGui() instanceof MenuScreen)) {
            event.setGui((Screen)new MenuScreen());
        }
    }

    @SubscribeEvent
    public void loadConfig(ConfigLoadedEvent event) {
        if (event.getConfigClass() == MiscConfig.class) {
            ModItems.feyDust.updateFood();
        }
    }

    @SubscribeEvent
    public void blockInteract(PlayerInteractEvent.RightClickBlock event) {
        BeeKnightEntity.anger(event.getWorld(), event.getPlayer(), event.getPos());
    }

    @SubscribeEvent
    public void blockInteract(PlayerInteractEvent.LeftClickBlock event) {
        BeeKnightEntity.anger(event.getWorld(), event.getPlayer(), event.getPos());
    }

    @SubscribeEvent
    public void tickWorld(TickEvent.WorldTickEvent event) {
        if (event.world instanceof ServerWorld && event.world.func_234923_W_() == World.field_234918_g_) {
            MarketHandler.update(((ServerWorld)event.world).func_73046_m());
        }
    }

    @SubscribeEvent
    public void afterReload(DatapacksReloadedEvent event) {
        FeywildMod.getNetwork().instance.send(PacketDistributor.ALL.noArg(), (Object)new TradesSerializer.Message(TradeManager.buildRecipes()));
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        if (event.getName().equals((Object)LootTables.field_186424_f) && (pool = event.getTable().getPool("main")) != null) {
            this.addEntry(pool, ItemLootEntry.func_216168_a((IItemProvider)ModItems.schematicsGemTransmutation).func_216086_a(8).func_216081_b());
            this.addEntry(pool, ItemLootEntry.func_216168_a((IItemProvider)ModItems.inactiveMarketRuneStone).func_216086_a(MiscConfig.rune_stone_weight).func_216081_b());
            this.addEntry(pool, ItemLootEntry.func_216168_a((IItemProvider)ModItems.lesserFeyGem).func_216086_a(30).func_216081_b());
            this.addEntry(pool, ItemLootEntry.func_216168_a((IItemProvider)ModItems.greaterFeyGem).func_216086_a(15).func_216081_b());
            this.addEntry(pool, ItemLootEntry.func_216168_a((IItemProvider)ModItems.shinyFeyGem).func_216086_a(8).func_216081_b());
            this.addEntry(pool, ItemLootEntry.func_216168_a((IItemProvider)ModItems.brilliantFeyGem).func_216086_a(4).func_216081_b());
            this.addEntry(pool, ItemLootEntry.func_216168_a((IItemProvider)ModItems.feywildMusicDisc).func_216086_a(2).func_216081_b());
        }
    }

    private void addEntry(LootPool pool, LootEntry entry) {
        try {
            List lootEntries = (List)ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a").get(pool);
            if (lootEntries.stream().noneMatch(e -> e == entry)) {
                lootEntries.add(entry);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

