/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block;

import com.feywild.feywild.block.entity.LibraryBell;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.quest.task.SpecialTask;
import com.feywild.feywild.quest.util.SpecialTaskAction;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.BlockTE;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LibraryBellBlock
extends BlockTE<LibraryBell> {
    public static final VoxelShape SHAPE = LibraryBellBlock.func_208617_a((double)5.1875, (double)0.0, (double)5.26563, (double)10.8125, (double)3.23438, (double)10.70313);

    public LibraryBellBlock(ModX mod) {
        super(mod, LibraryBell.class, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(-1.0f, 3600000.0f).func_222380_e().func_226896_b_().func_200944_c().func_200942_a().func_200947_a(SoundType.field_185851_d));
    }

    public void func_196243_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean moving) {
        if (!world.field_72995_K && world instanceof ServerWorld) {
            Entity security;
            LibraryBell tile = (LibraryBell)this.getTile(world, pos);
            if (tile.getLibrarian() != null) {
                Entity librarian = ((ServerWorld)world).func_217461_a(tile.getLibrarian());
                if (librarian instanceof VillagerEntity) {
                    ((VillagerEntity)librarian).func_242369_fq();
                }
                if (librarian != null) {
                    librarian.func_70106_y();
                }
            }
            if (tile.getSecurity() != null && (security = ((ServerWorld)world).func_217461_a(tile.getSecurity())) != null) {
                security.func_70106_y();
            }
        }
        super.func_196243_a(state, world, pos, newState, moving);
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult trace) {
        if (world.field_72995_K) {
            world.func_184133_a(player, pos, SoundEvents.field_193807_ew, SoundCategory.BLOCKS, 1.0f, 1.2f);
        } else {
            LibraryBell blockEntity = (LibraryBell)this.getTile(world, pos);
            if (player.func_146103_bH().getId().equals(blockEntity.getPlayer())) {
                blockEntity.setAnnoyance(blockEntity.getAnnoyance() + 1);
            } else {
                blockEntity.setPlayer(player.func_146103_bH().getId());
                blockEntity.setAnnoyance(0);
            }
            if (world instanceof ServerWorld) {
                Entity security;
                Entity librarian = blockEntity.getLibrarian() != null ? ((ServerWorld)world).func_217461_a(blockEntity.getLibrarian()) : null;
                Entity entity = security = blockEntity.getSecurity() != null ? ((ServerWorld)world).func_217461_a(blockEntity.getSecurity()) : null;
                if (blockEntity.getAnnoyance() >= 10 && librarian != null && librarian.func_70089_S()) {
                    blockEntity.setAnnoyance(0);
                    if (security == null) {
                        IronGolemEntity golem = new IronGolemEntity(EntityType.field_200757_aw, world);
                        golem.func_70849_f(false);
                        golem.func_70624_b((LivingEntity)player);
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild.bell.angry"), player.func_110124_au());
                        golem.func_70107_b(librarian.func_226277_ct_(), librarian.func_226278_cu_(), librarian.func_226281_cx_());
                        world.func_217376_c((Entity)golem);
                        blockEntity.setSecurity(golem.func_110124_au());
                        QuestData.get((ServerPlayerEntity)player).checkComplete(SpecialTask.INSTANCE, SpecialTaskAction.ANNOY_LIBRARIAN);
                    } else {
                        security.func_70107_b(librarian.func_226277_ct_(), librarian.func_226278_cu_(), librarian.func_226281_cx_());
                        if (security instanceof MobEntity) {
                            ((MobEntity)security).func_70624_b((LivingEntity)player);
                        }
                    }
                } else if (blockEntity.getAnnoyance() > 6) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.feywild.bell.annoyed"), player.func_110124_au());
                }
                if (librarian != null && librarian.func_70089_S()) {
                    if (librarian instanceof VillagerEntity) {
                        ((VillagerEntity)librarian).func_242369_fq();
                    }
                    librarian.func_70106_y();
                }
                VillagerEntity entity2 = new VillagerEntity(EntityType.field_200756_av, world);
                entity2.func_184211_a("feywild_librarian");
                entity2.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                for (Direction dir : Direction.values()) {
                    BlockPos target;
                    if (dir.func_176740_k() == Direction.Axis.Y || !world.func_180495_p(target = pos.func_177977_b().func_177972_a(dir)).func_196958_f()) continue;
                    entity2.func_70107_b((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5);
                    break;
                }
                world.func_217376_c((Entity)entity2);
                blockEntity.setLibrarian(entity2.func_110124_au());
                QuestData.get((ServerPlayerEntity)player).checkComplete(SpecialTask.INSTANCE, SpecialTaskAction.SUMMON_LIBRARIAN);
            }
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        LibraryBell entity = (LibraryBell)world.func_175625_s(pos);
        if (world.func_217461_a(entity.getSecurity()) != null) {
            entity.setDespawnTimer(entity.getDespawnTimer() + 1);
            if (entity.getDespawnTimer() >= 2) {
                entity.setDespawnTimer(0);
                world.func_217461_a(entity.getSecurity()).func_70106_y();
            }
        }
    }
}

