/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.entity;

import com.feywild.feywild.block.DisplayGlassBlock;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.item.ModItems;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.ItemStackHandlerWrapper;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DisplayGlass
extends TileEntityBase
implements ITickableTileEntity {
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(1, slot -> {
        this.func_70296_d();
        this.markDispatchable();
    });
    private final LazyOptional<IItemHandlerModifiable> itemHandler;
    private int generationCoolDown = 0;
    private int hitCounter = 0;

    public DisplayGlass(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.inventory.setDefaultSlotLimit(1);
        this.itemHandler = ItemStackHandlerWrapper.createLazy(() -> this.inventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.generationCoolDown == 0 && this.getInventory().getStackInSlot(0).func_190926_b() && ((Boolean)this.func_195044_w().func_177229_b((Property)DisplayGlassBlock.CAN_GENERATE)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)DisplayGlassBlock.BREAKAGE, (Comparable)Integer.valueOf(0)), 3);
                this.func_145836_u();
                this.inventory.getUnrestricted().insertItem(0, new ItemStack((IItemProvider)ModItems.honeycomb), false);
                this.generationCoolDown = -1;
            } else if (this.generationCoolDown > 0) {
                --this.generationCoolDown;
            }
            this.func_70296_d();
        }
    }

    public void hitGlass() {
        if (this.field_145850_b != null) {
            ++this.hitCounter;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187565_bO, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (this.hitCounter > 3) {
                if ((Integer)this.func_195044_w().func_177229_b((Property)DisplayGlassBlock.BREAKAGE) == 3) {
                    this.generationCoolDown = WorldGenConfig.structures.bee_keep.honey_timer;
                }
                if ((Integer)this.func_195044_w().func_177229_b((Property)DisplayGlassBlock.BREAKAGE) < 4) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)DisplayGlassBlock.BREAKAGE, (Comparable)Integer.valueOf((Integer)this.func_195044_w().func_177229_b((Property)DisplayGlassBlock.BREAKAGE) + 1)), 3);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.hitCounter = 0;
                    this.func_145836_u();
                }
            }
            this.func_70296_d();
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        nbt.func_74768_a("GenerationCoolDown", this.generationCoolDown);
        nbt.func_74768_a("Hits", this.hitCounter);
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l("Inventory"));
        this.generationCoolDown = nbt.func_74762_e("GenerationCoolDown");
        this.hitCounter = nbt.func_74762_e("Hits");
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            nbt.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        }
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.inventory.deserializeNBT(nbt.func_74775_l("Inventory"));
        }
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }
}

