/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.entity;

import com.feywild.feywild.block.entity.mana.CapabilityMana;
import com.feywild.feywild.block.entity.mana.IManaStorage;
import com.feywild.feywild.block.entity.mana.ManaStorage;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.recipes.IDwarvenAnvilRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.feywild.feywild.tag.ModItemTags;
import com.feywild.feywild.util.StreamUtil;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.ItemStackHandlerWrapper;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class DwarvenAnvil
extends TileEntityBase
implements ITickableTileEntity {
    public static final int MAX_MANA = 1000;
    public static final int FEY_DUST_MANA_COST = 50;
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(8, slot -> {
        this.func_70296_d();
        this.updateRecipe();
    }, this::isItemValid);
    private final ManaStorage manaStorage = new ManaStorage(1000, () -> {
        this.func_70296_d();
        this.updateRecipe();
    });
    private final LazyOptional<IItemHandlerModifiable> itemHandlerGeneric = ItemStackHandlerWrapper.createLazy(() -> this.inventory);
    private final LazyOptional<IItemHandlerModifiable> itemHandlerTop = ItemStackHandlerWrapper.createLazy(() -> this.inventory, slot -> false, (slot, stack) -> slot >= 2 && slot < 7);
    private final LazyOptional<IItemHandlerModifiable> itemHandlerSide = ItemStackHandlerWrapper.createLazy(() -> this.inventory, slot -> false, (slot, stack) -> slot < 2);
    private final LazyOptional<IItemHandlerModifiable> itemHandlerBottom = ItemStackHandlerWrapper.createLazy(() -> this.inventory, slot -> slot == 7, (slot, stack) -> false);
    private final LazyOptional<IManaStorage> manaHandler = LazyOptional.of(() -> this.manaStorage);
    private boolean needsUpdate = false;
    private LazyValue<Optional<Pair<ItemStack, IDwarvenAnvilRecipe>>> recipe = new LazyValue(Optional::empty);

    public DwarvenAnvil(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    private boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.func_77973_b() == ModItems.feyDust;
            }
            case 1: {
                return ModItemTags.SCHEMATICS.func_230235_a_((Object)stack.func_77973_b());
            }
            case 7: {
                return false;
            }
        }
        return this.field_145850_b == null || RecipeHelper.isItemValidInput((RecipeManager)this.field_145850_b.func_199532_z(), ModRecipeTypes.DWARVEN_ANVIL, (ItemStack)stack);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.itemHandlerTop.invalidate();
        this.itemHandlerSide.invalidate();
        this.itemHandlerBottom.invalidate();
        this.manaHandler.invalidate();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && this.field_145850_b instanceof ServerWorld) {
            ItemStack extracted;
            if (this.needsUpdate) {
                this.updateRecipe();
                this.needsUpdate = false;
            }
            if (((ServerWorld)this.field_145850_b).func_73046_m().func_71259_af() % 20 == 0 && this.manaStorage.getMana() + 50 <= this.manaStorage.getMaxMana() && !(extracted = this.inventory.extractItem(0, 1, true)).func_190926_b() && extracted.func_77973_b() == ModItems.feyDust) {
                this.inventory.extractItem(0, 1, false);
                this.manaStorage.receiveMana(50, false);
                this.func_70296_d();
            }
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        nbt.func_218657_a("mana", (INBT)this.manaStorage.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.manaStorage.deserializeNBT(nbt.func_74775_l("mana"));
        this.needsUpdate = true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.itemHandlerGeneric.cast();
            }
            switch (side) {
                case UP: {
                    return this.itemHandlerTop.cast();
                }
                case DOWN: {
                    return this.itemHandlerBottom.cast();
                }
            }
            return this.itemHandlerSide.cast();
        }
        if (capability == CapabilityMana.MANA) {
            return this.manaHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void craft() {
        ((Optional)this.recipe.func_179281_c()).ifPresent(pair -> {
            ItemStack result = (ItemStack)pair.getLeft();
            IDwarvenAnvilRecipe recipe = (IDwarvenAnvilRecipe)pair.getRight();
            this.manaStorage.extractMana(recipe.getMana(), false);
            IntStream.range(2, 7).forEach(slot -> this.inventory.extractItem(slot, 1, false));
            this.inventory.getUnrestricted().insertItem(7, result.func_77946_l(), false);
        });
    }

    private void updateRecipe() {
        this.recipe = this.field_145850_b == null || this.field_145850_b.field_72995_K ? new LazyValue(Optional::empty) : new LazyValue(() -> {
            ItemStack schematics = this.inventory.getStackInSlot(1);
            List inputs = IntStream.range(2, 7).mapToObj(arg_0 -> ((BaseItemStackHandler)this.inventory).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
            return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipeTypes.DWARVEN_ANVIL).stream().flatMap(r -> StreamUtil.zipOption(r.getResult(schematics, inputs), r)).findFirst().filter(p -> ((IDwarvenAnvilRecipe)p.getRight()).getMana() <= this.manaStorage.getMana()).filter(p -> this.inventory.getUnrestricted().insertItem(7, (ItemStack)p.getLeft(), true).func_190926_b());
        });
    }

    public boolean canCraft() {
        return ((Optional)this.recipe.func_179281_c()).isPresent();
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getMana() {
        return this.manaStorage.getMana();
    }

    public void setMana(int mana) {
        this.manaStorage.setMana(mana);
    }
}

