/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.entity;

import com.feywild.feywild.recipes.IAltarRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.feywild.feywild.util.StreamUtil;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.ItemStackHandlerWrapper;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class FeyAltar
extends TileEntityBase
implements ITickableTileEntity,
IAnimatable {
    public static final int MAX_PROGRESS = 40;
    private final BaseItemStackHandler inventory;
    private int progress = 0;
    private int particleTimer = 0;
    private boolean needsUpdate = false;
    private LazyValue<Optional<Pair<ItemStack, IAltarRecipe>>> recipe = new LazyValue(Optional::empty);
    private final LazyOptional<IItemHandlerModifiable> itemHandler;
    private final AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);

    public FeyAltar(TileEntityType<?> type) {
        super(type);
        this.inventory = new BaseItemStackHandler(5, slot -> {
            this.func_70296_d();
            this.updateRecipe();
            this.markDispatchable();
        });
        this.inventory.setDefaultSlotLimit(1);
        this.itemHandler = ItemStackHandlerWrapper.createLazy(() -> this.inventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.updateRecipe();
                this.needsUpdate = false;
            }
            if (((Optional)this.recipe.func_179281_c()).isPresent()) {
                Pair currentRecipe = (Pair)((Optional)this.recipe.func_179281_c()).get();
                ++this.progress;
                if (this.progress >= 40) {
                    for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                        this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
                    }
                    ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.5, ((ItemStack)currentRecipe.getLeft()).func_77946_l());
                    this.field_145850_b.func_217376_c((Entity)entity);
                    this.progress = 0;
                }
                this.func_70296_d();
                this.markDispatchable();
            } else {
                this.progress = 0;
            }
        } else if (this.progress > 0) {
            if (this.progress >= 39) {
                for (int i = 0; i < 20; ++i) {
                    this.field_145850_b.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5, 0.5 - this.field_145850_b.field_73012_v.nextDouble(), 0.7 - this.field_145850_b.field_73012_v.nextDouble(), 0.5 - this.field_145850_b.field_73012_v.nextDouble());
                }
                this.progress = 0;
            } else {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int slot = 0; slot < this.getInventory().getSlots(); ++slot) {
                    ItemStack stack = this.getInventory().getStackInSlot(slot);
                    if (stack.func_190926_b()) continue;
                    stacks.add(stack);
                }
                if (!stacks.isEmpty()) {
                    double progressScaled = (double)this.progress / 40.0;
                    double anglePerStack = Math.PI * 2 / (double)stacks.size();
                    for (int idx = 0; idx < stacks.size(); ++idx) {
                        double shiftX = Math.cos((double)this.field_145850_b.func_82737_E() / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                        double shiftZ = Math.sin((double)this.field_145850_b.func_82737_E() / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                        this.field_145850_b.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, (double)this.field_174879_c.func_177958_n() + 0.5 + shiftX, (double)(this.field_174879_c.func_177956_o() + 1) + progressScaled, (double)this.field_174879_c.func_177952_p() + 0.5 + shiftZ, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else if (this.particleTimer <= 0) {
            this.particleTimer = this.field_145850_b.field_73012_v.nextInt(120);
            if ((double)this.field_145850_b.field_73012_v.nextFloat() < 0.5) {
                this.field_145850_b.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void updateRecipe() {
        this.recipe = this.field_145850_b != null && !this.field_145850_b.field_72995_K ? new LazyValue(() -> {
            List inputs = IntStream.range(0, this.inventory.getSlots()).mapToObj(arg_0 -> ((BaseItemStackHandler)this.inventory).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
            return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipeTypes.ALTAR).stream().flatMap(r -> StreamUtil.zipOption(r.getResult(inputs), r)).findFirst();
        }) : new LazyValue(Optional::empty);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getProgress() {
        return this.progress;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        nbt.func_74768_a("progress", this.progress);
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.progress = nbt.func_74762_e("progress");
        this.needsUpdate = true;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            nbt.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
            nbt.func_74768_a("progress", this.progress);
        }
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
            this.progress = nbt.func_74762_e("progress");
        }
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.altar.motion", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }
}

