/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.flower;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.block.flower.GiantFlowerBlock;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.quest.task.SpecialTask;
import com.feywild.feywild.quest.util.SpecialTaskAction;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DandelionBlock
extends GiantFlowerBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.func_177719_a((String)"variant", (int)0, (int)3);

    public DandelionBlock(ModX mod) {
        super(mod, 4);
    }

    @Override
    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{VARIANT});
    }

    @Override
    protected void tickFlower(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((Property)VARIANT) == 3 && world.field_73012_v.nextInt(3) == 0) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(2)), 3);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (this.replaceFlower(world, pos.func_177981_b(3 - (Integer)state.func_177229_b((Property)PART)))) {
            if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
                QuestData.get((ServerPlayerEntity)player).checkComplete(SpecialTask.INSTANCE, SpecialTaskAction.DANDELION);
            }
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    private boolean replaceFlower(@Nonnull World world, @Nonnull BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this && (Integer)state.func_177229_b((Property)PART) == 3 && (Integer)state.func_177229_b((Property)VARIANT) == 2) {
            if (!world.field_72995_K) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(3)), 3);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_196243_a(@Nonnull BlockState oldState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean moving) {
        super.func_196243_a(oldState, world, pos, newState, moving);
        if ((Integer)oldState.func_177229_b((Property)VARIANT) == 2) {
            FeywildMod.getNetwork().sendParticles(world, ParticleSerializer.Type.DANDELION_FLUFF, pos);
        }
    }

    public float func_180647_a(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return (Integer)state.func_177229_b((Property)PART) == 3 && (Integer)state.func_177229_b((Property)VARIANT) == 2 ? 1.0f : super.func_180647_a(state, player, world, pos);
    }

    @Override
    protected void animateFlower(BlockState state, World world, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((Property)VARIANT) == 2 && random.nextDouble() < 0.4) {
            double windStrength = Math.cos((double)world.func_82737_E() / 2000.0) / 8.0;
            double windX = Math.cos((double)world.func_82737_E() / 1200.0) * windStrength;
            double windZ = Math.sin((double)world.func_82737_E() / 1000.0) * windStrength;
            world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble(), windX, 0.0, windZ);
        }
    }

    @Override
    public BlockState flowerState(IWorld world, BlockPos pos, Random random) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(random.nextInt(3)));
    }
}

