/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.feywild.feywild.block.trees.BaseSaplingBlock;
import com.feywild.feywild.block.trees.FeyLeavesBlock;
import com.feywild.feywild.block.trees.FeyLogBlock;
import com.feywild.feywild.block.trees.FeyWoodBlock;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.trees.Tree;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.MegaJungleTrunkPlacer;
import net.minecraft.world.server.ServerWorld;

public abstract class BaseTree
extends Tree
implements Registerable {
    private static final int BASE_HEIGHT = 6;
    private static final int FIRST_RANDOM_HEIGHT = 7;
    private static final int SECOND_RANDOM_HEIGHT = 8;
    private static final int LEAVES_RADIUS = 5;
    private static final int LEAVES_OFFSET = 4;
    private static final int LEAVES_HEIGHT = 5;
    private final FeyLogBlock logBlock = new FeyLogBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196620_N).func_200947_a(SoundType.field_185848_a));
    private final FeyWoodBlock woodBlock = new FeyWoodBlock(this.logBlock, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196634_T).func_200947_a(SoundType.field_185848_a));
    private final BlockItem logItem;
    private final BlockItem woodItem;
    private final Registerable logRegister;
    private final Registerable woodRegister;
    private final FeyLeavesBlock leaves;
    private final BaseSaplingBlock sapling;

    public BaseTree(ModX mod, Supplier<? extends FeyLeavesBlock> leavesFactory) {
        Item.Properties properties = mod.tab == null ? new Item.Properties() : new Item.Properties().func_200916_a(mod.tab);
        this.logItem = new BlockItem((Block)this.logBlock, properties);
        this.woodItem = new BlockItem((Block)this.woodBlock, properties);
        this.logRegister = new Registerable(){

            public Set<Object> getAdditionalRegisters() {
                return ImmutableSet.of((Object)((Object)BaseTree.this.logBlock), (Object)BaseTree.this.logItem);
            }
        };
        this.woodRegister = new Registerable(){

            public Set<Object> getAdditionalRegisters() {
                return ImmutableSet.of((Object)((Object)BaseTree.this.woodBlock), (Object)BaseTree.this.woodItem);
            }
        };
        this.leaves = leavesFactory.get();
        this.sapling = new BaseSaplingBlock(mod, this);
    }

    public Map<String, Object> getNamedAdditionalRegisters() {
        return ImmutableMap.of((Object)"log", (Object)this.logRegister, (Object)"wood", (Object)this.woodRegister, (Object)"leaves", (Object)((Object)this.leaves), (Object)"sapling", (Object)((Object)this.sapling));
    }

    @Nonnull
    public ConfiguredFeature<BaseTreeFeatureConfig, ?> func_225546_b_(@Nonnull Random random, boolean largeHive) {
        BaseTreeFeatureConfig featureConfig = this.getFeatureBuilder(random, largeHive).func_225568_b_();
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)featureConfig);
    }

    protected BaseTreeFeatureConfig.Builder getFeatureBuilder(@Nonnull Random random, boolean largeHive) {
        return new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(this.getLogBlock().func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(this.getLeafBlock().func_176223_P()), this.getFoliagePlacer(), this.getGiantTrunkPlacer(), (AbstractFeatureSizeType)this.getTwoLayerFeature());
    }

    protected FoliagePlacer getFoliagePlacer() {
        return new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)this.getLeavesRadius()), FeatureSpread.func_242252_a((int)this.getLeavesOffset()), this.getLeavesHeight());
    }

    protected AbstractTrunkPlacer getGiantTrunkPlacer() {
        return new MegaJungleTrunkPlacer(this.getBaseHeight(), this.getFirstRandomHeight(), this.getSecondRandomHeight());
    }

    protected TwoLayerFeature getTwoLayerFeature() {
        return new TwoLayerFeature(1, 0, 1);
    }

    public abstract void decorateSaplingGrowth(ServerWorld var1, BlockPos var2, Random var3);

    public Block getLogBlock() {
        return this.logBlock;
    }

    public Block getWoodBlock() {
        return this.woodBlock;
    }

    public Block getLeafBlock() {
        return this.leaves;
    }

    public Block getSapling() {
        return this.sapling;
    }

    protected int getLeavesRadius() {
        return 5;
    }

    protected int getLeavesOffset() {
        return 4;
    }

    protected int getLeavesHeight() {
        return 5;
    }

    protected int getBaseHeight() {
        return 6;
    }

    protected int getFirstRandomHeight() {
        return 7;
    }

    protected int getSecondRandomHeight() {
        return 8;
    }

    public boolean func_230339_a_(@Nonnull ServerWorld world, @Nonnull ChunkGenerator generator, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Random random) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || world.func_217375_a(pos.func_177982_a(i, 0, j), AbstractBlock.AbstractBlockState::func_196958_f) || world.func_217375_a(pos.func_177982_a(i, 0, j), blockState -> blockState.func_185904_a().equals(Material.field_151582_l))) continue;
                return false;
            }
        }
        super.func_230339_a_(world, generator, pos, state, random);
        return true;
    }
}

