/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.data.recipe;

import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.data.CraftingHelper2;
import io.github.noeppi_noeppi.libx.data.provider.recipe.AnyRecipeProvider;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class AnvilRecipes
extends AnyRecipeProvider {
    public AnvilRecipes(ModX mod, DataGenerator generator) {
        super(mod, generator);
    }

    @Nonnull
    public String func_200397_b() {
        return this.mod.modid + " fey anvil recipes";
    }

    protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> consumer) {
        this.gemTransmutation(consumer, (IItemProvider)ModItems.lesserFeyGem, (IItemProvider)ModItems.greaterFeyGem, 50);
        this.gemTransmutation(consumer, (IItemProvider)ModItems.greaterFeyGem, (IItemProvider)ModItems.shinyFeyGem, 100);
        this.gemTransmutation(consumer, (IItemProvider)ModItems.shinyFeyGem, (IItemProvider)ModItems.brilliantFeyGem, 150);
    }

    private void gemTransmutation(Consumer<IFinishedRecipe> consumer, IItemProvider input, IItemProvider result, int mana) {
        this.anvil(result, 2).requires(input).requires(input).requires(input).requires(input).requires(input).schematics((IItemProvider)ModItems.schematicsGemTransmutation).mana(mana).build(consumer);
    }

    private AnvilRecipeBuilder anvil(IItemProvider result) {
        return this.anvil(new ItemStack(result));
    }

    private AnvilRecipeBuilder anvil(IItemProvider result, int amount) {
        return this.anvil(new ItemStack(result, amount));
    }

    private AnvilRecipeBuilder anvil(ItemStack result) {
        return new AnvilRecipeBuilder(result);
    }

    private class AnvilRecipeBuilder {
        private final ItemStack result;
        private final List<Ingredient> inputs;
        @Nullable
        private Ingredient schematics;
        private int mana = -1;

        public AnvilRecipeBuilder(ItemStack result) {
            this.result = result;
            this.inputs = new ArrayList<Ingredient>();
        }

        public AnvilRecipeBuilder requires(IItemProvider item) {
            return this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        }

        public AnvilRecipeBuilder requires(ITag<Item> item) {
            return this.requires(Ingredient.func_199805_a(item));
        }

        public AnvilRecipeBuilder requires(Ingredient item) {
            this.inputs.add(item);
            return this;
        }

        public AnvilRecipeBuilder schematics(IItemProvider item) {
            return this.schematics(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        }

        public AnvilRecipeBuilder schematics(ITag<Item> item) {
            return this.schematics(Ingredient.func_199805_a(item));
        }

        public AnvilRecipeBuilder schematics(Ingredient item) {
            if (this.schematics != null) {
                throw new IllegalStateException("Can't build dwarven anvil recipe with multiple schematics");
            }
            this.schematics = item;
            return this;
        }

        public AnvilRecipeBuilder mana(int mana) {
            if (this.mana >= 0) {
                throw new IllegalStateException("Mana can only set once per dwarven anvil recipe.");
            }
            this.mana = mana;
            return this;
        }

        public void build(Consumer<IFinishedRecipe> consumer) {
            this.build(consumer, AnvilRecipes.this.loc((IItemProvider)this.result.func_77973_b(), "dwarven_anvil"));
        }

        public void build(Consumer<IFinishedRecipe> consumer, final ResourceLocation id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Can't build dwarven anvil recipe without inputs: " + id);
            }
            if (this.inputs.size() > 5) {
                throw new IllegalStateException("Can't build dwarven anvil recipe with more than 5 inputs: " + id);
            }
            if (this.mana < 0) {
                throw new IllegalStateException("mana not set for dwarven anvil recipe: " + id);
            }
            consumer.accept(new IFinishedRecipe(){

                public void func_218610_a(@Nonnull JsonObject json) {
                    json.addProperty("mana", (Number)AnvilRecipeBuilder.this.mana);
                    json.add("output", (JsonElement)CraftingHelper2.serializeItemStack((ItemStack)AnvilRecipeBuilder.this.result, (boolean)true));
                    if (AnvilRecipeBuilder.this.schematics != null) {
                        json.add("schematics", AnvilRecipeBuilder.this.schematics.func_200304_c());
                    }
                    JsonArray inputList = new JsonArray();
                    AnvilRecipeBuilder.this.inputs.forEach(i -> inputList.add(i.func_200304_c()));
                    json.add("ingredients", (JsonElement)inputList);
                }

                @Nonnull
                public ResourceLocation func_200442_b() {
                    return id;
                }

                @Nonnull
                public IRecipeSerializer<?> func_218609_c() {
                    return ModRecipeTypes.DWARVEN_ANVIL_SERIALIZER;
                }

                @Nullable
                public JsonObject func_200440_c() {
                    return null;
                }

                @Nullable
                public ResourceLocation func_200443_d() {
                    return null;
                }
            });
        }
    }
}

