/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.base;

import com.feywild.feywild.trade.TradeManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class TraderEntity
extends AbstractVillagerEntity
implements IReputationTracking {
    private int villagerXp;
    private int updateMerchantTimer;
    private boolean increaseProfessionLevelOnUpdate;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;
    private VillagerData villagerData = new VillagerData(VillagerType.field_221175_c, VillagerProfession.field_221164_n, 1);

    public TraderEntity(EntityType<? extends AbstractVillagerEntity> entity, World world) {
        super(entity, world);
    }

    public abstract String getTradeCategory();

    protected void func_213713_b(MerchantOffer offer) {
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.villagerXp += offer.func_222210_n();
        if (this.shouldIncreaseLevel()) {
            this.updateMerchantTimer = 40;
            this.increaseProfessionLevelOnUpdate = true;
            i += 5;
        }
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    protected void func_213712_ef() {
        this.field_213724_bz = new MerchantOffers();
        this.villagerData = TradeManager.getTrades(this.func_200600_R(), this.getTradeCategory()).initialize((Entity)this, this.villagerData, this.field_213724_bz, this.field_70146_Z);
    }

    protected void levelUp() {
        this.villagerData = TradeManager.getTrades(this.func_200600_R(), this.getTradeCategory()).levelUp((Entity)this, this.villagerData, this.field_213724_bz, this.field_70146_Z);
    }

    public void func_213281_b(@Nonnull CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("VillagerLevel", this.villagerData.func_221132_c());
        nbt.func_74768_a("VillagerXp", this.villagerXp);
        nbt.func_74772_a("LastRestock", this.lastRestockGameTime);
        nbt.func_74768_a("RestocksToday", this.numberOfRestocksToday);
    }

    public void func_70037_a(@Nonnull CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.villagerData = new VillagerData(VillagerType.field_221175_c, VillagerProfession.field_221164_n, nbt.func_74764_b("VillagerLevel") ? nbt.func_74762_e("VillagerLevel") : 1);
        if (nbt.func_150297_b("VillagerXp", 99)) {
            this.villagerXp = nbt.func_74762_e("VillagerXp");
        }
        this.lastRestockGameTime = nbt.func_74763_f("LastRestock");
        this.numberOfRestocksToday = nbt.func_74762_e("RestocksToday");
    }

    private boolean shouldIncreaseLevel() {
        int i = this.getVillagerData().func_221132_c();
        return VillagerData.func_221128_d((int)i) && this.villagerXp >= VillagerData.func_221127_c((int)i);
    }

    protected void func_70619_bc() {
        if (!this.func_213716_dX() && this.updateMerchantTimer > 0) {
            --this.updateMerchantTimer;
            if (this.updateMerchantTimer <= 0) {
                if (this.increaseProfessionLevelOnUpdate) {
                    this.levelUp();
                    this.increaseProfessionLevelOnUpdate = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public VillagerData getVillagerData() {
        return this.villagerData;
    }

    public int func_213708_dV() {
        return this.villagerXp;
    }

    public void func_213739_a(@Nonnull IReputationType p_213739_1_, @Nonnull Entity p_213739_2_) {
    }

    @Nullable
    public AgeableEntity func_241840_a(@Nonnull ServerWorld p_241840_1_, @Nonnull AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public boolean func_223340_ej() {
        return true;
    }

    public void restock() {
        this.updateDemand();
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
        this.lastRestockGameTime = this.field_70170_p.func_82737_E();
        ++this.numberOfRestocksToday;
    }

    private boolean needsToRestock() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            if (!merchantoffer.func_226654_r_()) continue;
            return true;
        }
        return false;
    }

    private boolean allowedToRestock() {
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < 2 && this.field_70170_p.func_82737_E() > this.lastRestockGameTime + 2400L;
    }

    public boolean shouldRestock() {
        boolean timeForRestock;
        boolean bl = timeForRestock = this.field_70170_p.func_82737_E() > this.lastRestockGameTime + 12000L;
        if (this.lastRestockCheckDayTime > 0L && !timeForRestock) {
            long lastRestockDay = this.lastRestockCheckDayTime / 24000L;
            long currentRestockDay = this.field_70170_p.func_72820_D() / 24000L;
            if (currentRestockDay > lastRestockDay) {
                timeForRestock = true;
            }
        }
        this.lastRestockCheckDayTime = this.field_70170_p.func_72820_D();
        if (timeForRestock) {
            this.lastRestockGameTime = this.field_70170_p.func_82737_E();
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void catchUpDemand() {
        int restocksLeft = 2 - this.numberOfRestocksToday;
        if (restocksLeft > 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222203_h();
            }
        }
        for (int j = 0; j < restocksLeft; ++j) {
            this.updateDemand();
        }
    }

    private void updateDemand() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222222_e();
        }
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }
}

