/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.entity.goals.MovementRestrictionGoal;
import java.util.function.Supplier;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class GoToTargetPositionGoal
extends MovementRestrictionGoal {
    private final MobEntity entity;
    private final Supplier<Boolean> shouldReturn;
    private final int triggerRangeSquared;
    private final float speed;

    public GoToTargetPositionGoal(MobEntity entity, Supplier<Vector3d> pos, int maxMovementRange, float speed) {
        super(pos, maxMovementRange);
        this.entity = entity;
        this.speed = speed;
        this.shouldReturn = () -> true;
        this.triggerRangeSquared = maxMovementRange * 2 * (maxMovementRange * 2);
    }

    public GoToTargetPositionGoal(MobEntity entity, Supplier<Vector3d> pos, int maxMovementRange, float speed, Supplier<Boolean> shouldReturn) {
        super(pos, maxMovementRange);
        this.entity = entity;
        this.speed = speed;
        this.shouldReturn = shouldReturn;
        this.triggerRangeSquared = maxMovementRange * 2 * (maxMovementRange * 2);
    }

    public void func_75246_d() {
        Vector3d target = (Vector3d)this.targetPosition.get();
        if (target != null && GoToTargetPositionGoal.distanceFromSquared(this.entity.func_213303_ch(), target) > (double)this.triggerRangeSquared) {
            this.entity.func_70107_b(target.field_72450_a, target.field_72448_b, target.field_72449_c);
        } else if (target != null && GoToTargetPositionGoal.distanceFromSquared(this.entity.func_213303_ch(), target) > (double)this.maxMovementRangeSquared) {
            this.entity.func_70661_as().func_75492_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, (double)this.speed);
        }
    }

    public boolean func_75253_b() {
        Vector3d target = (Vector3d)this.targetPosition.get();
        return target != null && GoToTargetPositionGoal.distanceFromSquared(this.entity.func_213303_ch(), target) > (double)this.maxMovementRangeSquared / 2.0 && this.shouldReturn.get() != false;
    }

    @Override
    public boolean func_75250_a() {
        Vector3d target = (Vector3d)this.targetPosition.get();
        return this.entity.field_70170_p.field_73012_v.nextFloat() < 0.25f && target != null && !this.isInRange(this.entity.func_213303_ch()) && this.shouldReturn.get() != false;
    }

    public static GoToTargetPositionGoal byBlockPos(MobEntity entity, Supplier<BlockPos> pos, int maxMovementRange, float speed) {
        return new GoToTargetPositionGoal(entity, GoToTargetPositionGoal.asVector(pos), maxMovementRange, speed);
    }

    public static GoToTargetPositionGoal byBlockPos(MobEntity entity, Supplier<BlockPos> pos, int maxMovementRange, float speed, Supplier<Boolean> shouldReturn) {
        return new GoToTargetPositionGoal(entity, GoToTargetPositionGoal.asVector(pos), maxMovementRange, speed, shouldReturn);
    }
}

