/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import java.util.function.Supplier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class MovementRestrictionGoal
extends Goal {
    public final Supplier<Vector3d> targetPosition;
    public final int maxMovementRangeSquared;

    public MovementRestrictionGoal(Supplier<Vector3d> pos, int maxMovementRange) {
        this.targetPosition = pos;
        this.maxMovementRangeSquared = maxMovementRange * maxMovementRange;
    }

    public static double distanceFromSquared(Vector3d start, Vector3d end) {
        return (start.field_72450_a - end.field_72450_a) * (start.field_72450_a - end.field_72450_a) + (start.field_72448_b - end.field_72448_b) * (start.field_72448_b - end.field_72448_b) + (start.field_72449_c - end.field_72449_c) * (start.field_72449_c - end.field_72449_c);
    }

    public boolean isInRange(Vector3d pos) {
        Vector3d target = this.targetPosition.get();
        return target != null && MovementRestrictionGoal.distanceFromSquared(pos, target) <= (double)this.maxMovementRangeSquared;
    }

    public boolean func_75250_a() {
        return false;
    }

    protected static Supplier<Vector3d> asVector(Supplier<BlockPos> pos) {
        return () -> {
            BlockPos block = (BlockPos)pos.get();
            return block == null ? null : new Vector3d((double)block.func_177958_n() + 0.5, (double)block.func_177956_o() + 0.5, (double)block.func_177952_p() + 0.5);
        };
    }
}

