/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.entity.base.PixieEntity;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.sound.ModSoundEvents;
import java.util.Objects;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class TargetFireGoal
extends Goal {
    private static final EntityPredicate TARGETING = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c();
    private final PixieEntity entity;
    private MonsterEntity targetMonster;
    private int ticksLeft = 0;

    public TargetFireGoal(PixieEntity entity) {
        this.entity = entity;
    }

    public void func_75246_d() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.targetMonster == null) {
                this.targetMonster = this.findTarget();
                if (this.targetMonster == null) {
                    this.reset();
                    return;
                }
            }
            if (this.ticksLeft <= 0) {
                this.targetMonster.func_70015_d(120);
                FeywildMod.getNetwork().sendParticles(this.entity.field_70170_p, ParticleSerializer.Type.MONSTER_FIRE, this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_(), this.targetMonster.func_226277_ct_(), this.targetMonster.func_226278_cu_(), this.targetMonster.func_226281_cx_());
                this.reset();
            } else if (this.ticksLeft == 110) {
                this.spellCasting();
            }
        }
    }

    private void spellCasting() {
        this.entity.func_200602_a(EntityAnchorArgument.Type.EYES, this.targetMonster.func_213303_ch());
        this.entity.setCasting(true);
        this.entity.func_184185_a(ModSoundEvents.pixieSpellcasting, 1.0f, 1.0f);
    }

    public void func_75249_e() {
        this.ticksLeft = 120;
        this.targetMonster = null;
    }

    protected void reset() {
        this.entity.setCasting(false);
        this.targetMonster = null;
        this.ticksLeft = -1;
    }

    public boolean func_75253_b() {
        return this.ticksLeft > 0;
    }

    public boolean func_75250_a() {
        if (this.entity.isTamed() && this.entity.getOwner() == null) {
            this.entity.unableToFollow();
            return false;
        }
        return this.entity.isTamed() && this.entity.field_70170_p.field_73012_v.nextFloat() < 0.005f && QuestData.get((ServerPlayerEntity)Objects.requireNonNull(this.entity.getOwner())).getAlignment() == this.entity.alignment;
    }

    private MonsterEntity findTarget() {
        double distance = Double.MAX_VALUE;
        MonsterEntity current = null;
        for (MonsterEntity monster : this.entity.field_70170_p.func_217374_a(MonsterEntity.class, TARGETING, (LivingEntity)this.entity, this.entity.func_174813_aQ().func_186662_g(8.0))) {
            if (!(this.entity.func_70068_e((Entity)monster) < distance) || monster.func_70027_ad()) continue;
            current = monster;
            distance = this.entity.func_70068_e((Entity)monster);
        }
        return current;
    }
}

