/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest;

import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.entity.base.PixieEntity;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;

public enum Alignment {
    SPRING("spring", ModEntityTypes.springPixie),
    SUMMER("summer", ModEntityTypes.summerPixie),
    AUTUMN("autumn", ModEntityTypes.autumnPixie),
    WINTER("winter", ModEntityTypes.winterPixie);

    public final String id;
    public final EntityType<? extends PixieEntity> fey;

    private Alignment(String id, EntityType<? extends PixieEntity> fey) {
        this.id = id;
        this.fey = fey;
    }

    public static Alignment byId(String id) {
        switch (id.toLowerCase(Locale.ROOT).trim()) {
            case "spring": {
                return SPRING;
            }
            case "summer": {
                return SUMMER;
            }
            case "autumn": {
                return AUTUMN;
            }
            case "winter": {
                return WINTER;
            }
        }
        throw new IllegalArgumentException("Invalid fey alignment: " + id);
    }

    public static String optionId(@Nullable Alignment alignment) {
        return alignment == null ? "unaligned" : alignment.id;
    }

    @Nullable
    public static Alignment byOptionId(String id) {
        try {
            return Alignment.byId(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

