/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class QuestDisplay {
    public final ITextComponent title;
    public final ITextComponent description;
    @Nullable
    public final SoundEvent sound;

    public QuestDisplay(ITextComponent title, ITextComponent description, @Nullable SoundEvent sound) {
        this.title = title;
        this.description = description;
        this.sound = sound;
    }

    public static QuestDisplay fromJson(JsonObject json) {
        IFormattableTextComponent title = ITextComponent.Serializer.func_240641_a_((JsonElement)json.get("title"));
        IFormattableTextComponent description = ITextComponent.Serializer.func_240641_a_((JsonElement)json.get("description"));
        SoundEvent sound = json.has("sound") ? (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(json.get("sound").getAsString())) : null;
        return new QuestDisplay((ITextComponent)title, (ITextComponent)description, sound);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("title", ITextComponent.Serializer.func_200528_b((ITextComponent)this.title));
        json.add("description", ITextComponent.Serializer.func_200528_b((ITextComponent)this.description));
        if (this.sound != null && this.sound.getRegistryName() != null) {
            json.addProperty("sound", this.sound.getRegistryName().toString());
        }
        return json;
    }

    public static QuestDisplay fromNetwork(PacketBuffer buffer) {
        ITextComponent title = buffer.func_179258_d();
        ITextComponent description = buffer.func_179258_d();
        SoundEvent sound = buffer.readBoolean() ? (SoundEvent)buffer.readRegistryId() : null;
        return new QuestDisplay(title, description, sound);
    }

    public void toNetwork(PacketBuffer buffer) {
        buffer.func_179256_a(this.title);
        buffer.func_179256_a(this.description);
        buffer.writeBoolean(this.sound != null);
        if (this.sound != null) {
            buffer.writeRegistryId((IForgeRegistryEntry)this.sound);
        }
    }
}

