/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest.player;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.quest.player.QuestData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class CapabilityQuests {
    public static final ResourceLocation KEY = new ResourceLocation(FeywildMod.getInstance().modid, "player_quests");
    @CapabilityInject(value=QuestData.class)
    public static Capability<QuestData> QUESTS = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(QuestData.class, (Capability.IStorage)new Capability.IStorage<QuestData>(){

            @Nullable
            public INBT writeNBT(Capability<QuestData> capability, QuestData instance, Direction side) {
                return instance.write();
            }

            public void readNBT(Capability<QuestData> capability, QuestData instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.read((CompoundNBT)nbt);
                }
            }
        }, QuestData::new);
    }

    public static void attachPlayerCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getObject();
            event.addCapability(KEY, (ICapabilityProvider)new Provider(QUESTS, new LazyValue(() -> {
                QuestData data = new QuestData();
                data.attach(player);
                return data;
            })));
        }
    }

    public static void playerCopy(PlayerEvent.Clone event) {
        event.getOriginal().getCapability(QUESTS).ifPresent(oldData -> event.getPlayer().getCapability(QUESTS).ifPresent(newData -> newData.read(oldData.write())));
    }

    private static class Provider
    implements ICapabilityProvider,
    INBTSerializable<INBT> {
        public final Capability<?> capability;
        public final LazyValue<?> value;

        public <T> Provider(Capability<T> capability, LazyValue<? extends T> value) {
            this.capability = capability;
            this.value = value;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == this.capability ? LazyOptional.of(() -> this.value.func_179281_c()).cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return this.capability.writeNBT(this.value.func_179281_c(), null);
        }

        public void deserializeNBT(INBT nbt) {
            this.capability.readNBT(this.value.func_179281_c(), null, nbt);
        }
    }
}

