/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.recipes;

import com.feywild.feywild.recipes.IDwarvenAnvilRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.feywild.feywild.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DwarvenAnvilRecipe
implements IDwarvenAnvilRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    @Nullable
    private final Ingredient schematics;
    private final List<Ingredient> inputs;
    private final NonNullList<Ingredient> inputList;
    private final int mana;

    public DwarvenAnvilRecipe(ResourceLocation id, ItemStack output, @Nullable Ingredient schematics, List<Ingredient> inputs, int mana) {
        this.id = id;
        this.output = output;
        this.schematics = schematics;
        this.inputs = ImmutableList.copyOf(inputs);
        this.inputList = NonNullList.func_191197_a((int)this.inputs.size(), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputList.set(i, (Object)this.inputs.get(i));
        }
        this.mana = mana;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.DWARVEN_ANVIL_SERIALIZER;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    @Nullable
    public Ingredient getSchematics() {
        return this.schematics;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputList;
    }

    @Override
    public Optional<ItemStack> getResult(ItemStack schematics, List<ItemStack> inputs) {
        if (this.schematics != null && (schematics.func_190926_b() || !this.schematics.test(schematics))) {
            return Optional.empty();
        }
        if (!Util.simpleMatch(this.inputs, inputs)) {
            return Optional.empty();
        }
        return Optional.of(this.func_77571_b());
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DwarvenAnvilRecipe> {
        @Nonnull
        public DwarvenAnvilRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            int mana = JSONUtils.func_151203_m((JsonObject)json, (String)"mana");
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
            Ingredient schematics = json.has("schematics") ? Ingredient.func_199802_a((JsonElement)json.get("schematics")) : null;
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement jsonElement : ingredients) {
                inputs.add(Ingredient.func_199802_a((JsonElement)jsonElement));
            }
            return new DwarvenAnvilRecipe(recipeId, output, schematics, inputs, mana);
        }

        @Nullable
        public DwarvenAnvilRecipe fromNetwork(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
            int mana = buffer.func_150792_a();
            Ingredient schematics = buffer.readBoolean() ? Ingredient.func_199566_b((PacketBuffer)buffer) : null;
            int inputSize = buffer.func_150792_a();
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (int i = 0; i < inputSize; ++i) {
                inputs.add((Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            return new DwarvenAnvilRecipe(recipeId, output, schematics, (List<Ingredient>)inputs.build(), mana);
        }

        public void toNetwork(PacketBuffer buffer, DwarvenAnvilRecipe recipe) {
            buffer.func_150787_b(recipe.mana);
            buffer.writeBoolean(recipe.schematics != null);
            if (recipe.schematics != null) {
                recipe.schematics.func_199564_a(buffer);
            }
            buffer.func_150787_b(recipe.inputs.size());
            recipe.inputs.forEach(i -> i.func_199564_a(buffer));
            buffer.writeItemStack(recipe.func_77571_b(), false);
        }
    }
}

