/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.trade;

import com.feywild.feywild.trade.TradeEntry;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.util.LazyValue;
import org.apache.commons.lang3.tuple.Pair;

public class TradeLevelData {
    private final int minTrades;
    private final int maxTrades;
    private final int maxWeight;
    private final boolean allowDuplicates;
    private final List<Pair<Integer, VillagerTrades.ITrade>> trades;
    private final LazyValue<List<VillagerTrades.ITrade>> tradeView;

    public TradeLevelData(int minTrades, int maxTrades, List<TradeEntry> trades, boolean allowDuplicates) {
        this.minTrades = Math.min(minTrades, maxTrades);
        this.maxTrades = Math.max(minTrades, maxTrades);
        int maxWeight = 0;
        ImmutableList.Builder weightedTrades = ImmutableList.builder();
        for (TradeEntry entry : trades) {
            if (entry.weight <= 0) continue;
            weightedTrades.add((Object)Pair.of((Object)(maxWeight += entry.weight), (Object)entry.trade));
        }
        this.maxWeight = maxWeight;
        this.trades = weightedTrades.build();
        this.allowDuplicates = allowDuplicates;
        if (this.minTrades < 0 || this.maxTrades <= 0) {
            throw new IllegalStateException("Trader level data must be able to select at least one trade. Current range: [" + this.minTrades + ";" + this.maxTrades + "]");
        }
        if (!this.allowDuplicates && this.trades.size() < this.maxTrades) {
            throw new IllegalStateException("Trader level data without duplicates must define at least as many trades as it can select. Current maximum selection: " + this.maxTrades + ". (Defines trades: " + this.trades.size() + ")");
        }
        this.tradeView = new LazyValue(() -> (List)this.trades.stream().map(Pair::getRight).collect(ImmutableList.toImmutableList()));
    }

    public void applyTo(Entity merchant, MerchantOffers offers, Random random) {
        int tradesToSelect = this.minTrades + random.nextInt(1 + (this.maxTrades - this.minTrades));
        List<VillagerTrades.ITrade> selected = this.selectTrades(tradesToSelect, random);
        for (VillagerTrades.ITrade trade : selected) {
            MerchantOffer offer = trade.func_221182_a(merchant, random);
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public List<VillagerTrades.ITrade> selectTrades(int trades, Random random) {
        int tradesToSelect;
        int n = tradesToSelect = this.allowDuplicates ? trades : Math.min(trades, this.trades.size());
        if (tradesToSelect == 0) {
            return ImmutableList.of();
        }
        if (tradesToSelect == 1) {
            return ImmutableList.of((Object)this.trades.get(this.selectRandomTrade(random)).getRight());
        }
        if (!this.allowDuplicates && tradesToSelect == this.trades.size()) {
            return (List)this.trades.stream().map(Pair::getRight).collect(ImmutableList.toImmutableList());
        }
        HashSet<Integer> usedIndices = new HashSet<Integer>();
        ImmutableList.Builder builtTrades = ImmutableList.builder();
        for (int i = 0; i < tradesToSelect; ++i) {
            int tradeIdx;
            while (usedIndices.contains(tradeIdx = this.selectRandomTrade(random))) {
            }
            if (!this.allowDuplicates) {
                usedIndices.add(tradeIdx);
            }
            builtTrades.add(this.trades.get(tradeIdx).getRight());
        }
        return builtTrades.build();
    }

    private int selectRandomTrade(Random random) {
        int id = random.nextInt(this.maxWeight);
        for (int i = 0; i < this.trades.size(); ++i) {
            if (id >= (Integer)this.trades.get(i).getLeft()) continue;
            return i;
        }
        return this.trades.size() - 1;
    }

    public List<VillagerTrades.ITrade> getAllTrades() {
        return (List)this.tradeView.func_179281_c();
    }

    public static TradeLevelData fromJson(JsonObject json) {
        int max;
        int min;
        JsonElement amount = json.get("amount");
        if (amount.isJsonArray() && amount.getAsJsonArray().size() == 2) {
            min = amount.getAsJsonArray().get(0).getAsInt();
            max = amount.getAsJsonArray().get(0).getAsInt();
        } else {
            min = amount.getAsInt();
            max = amount.getAsInt();
        }
        ImmutableList.Builder trades = ImmutableList.builder();
        for (JsonElement elem : json.get("trades").getAsJsonArray()) {
            trades.add((Object)TradeEntry.fromJson(elem.getAsJsonObject()));
        }
        boolean allowDuplicates = json.has("duplicates") && json.get("duplicates").getAsBoolean();
        return new TradeLevelData(min, max, (List<TradeEntry>)trades.build(), allowDuplicates);
    }
}

