/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.trade.item;

import com.feywild.feywild.trade.item.CompoundStackFactory;
import com.feywild.feywild.trade.item.SimpleStackFactory;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public interface StackFactory {
    public ItemStack createStack(Random var1);

    public static StackFactory fromJson(JsonElement json) {
        CompoundNBT nbt;
        int max;
        int min;
        if (json.isJsonArray()) {
            ImmutableList.Builder factories = ImmutableList.builder();
            for (JsonElement elem : json.getAsJsonArray()) {
                factories.add((Object)StackFactory.fromJson(elem));
            }
            return new CompoundStackFactory((List<StackFactory>)factories.build());
        }
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("count")) {
            if (obj.get("count").isJsonArray() && obj.get("count").getAsJsonArray().size() == 2) {
                min = obj.get("count").getAsJsonArray().get(0).getAsInt();
                max = obj.get("count").getAsJsonArray().get(1).getAsInt();
            } else {
                min = obj.get("count").getAsInt();
                max = obj.get("count").getAsInt();
            }
        } else {
            min = 1;
            max = 1;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(obj.get("item").getAsString()));
        if (item == null) {
            throw new IllegalStateException("Can't create stack factory without item");
        }
        try {
            nbt = obj.has("nbt") && obj.get("nbt").isJsonPrimitive() ? JsonToNBT.func_180713_a((String)obj.get("nbt").getAsString()) : (obj.has("nbt") ? JsonToNBT.func_180713_a((String)obj.get("nbt").toString()) : null);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalStateException("Invalid NBT", e);
        }
        return new SimpleStackFactory(new ItemStack((IItemProvider)item, min, nbt), min, max);
    }
}

