/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModList;

public class DatapackHelper {
    public static final Gson GSON = ((Supplier<Gson>)() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.setPrettyPrinting();
        return builder.create();
    }).get();

    public static <T> Map<ResourceLocation, T> loadData(IResourceManager rm, String path, BiFunction<ResourceLocation, JsonElement, T> factory) {
        try {
            ImmutableMap.Builder map = ImmutableMap.builder();
            Collection ids = rm.func_199003_a(path, file -> file.endsWith(".json"));
            for (ResourceLocation id : ids) {
                String realPath = id.func_110623_a();
                if (realPath.startsWith(path) && (realPath = realPath.substring(path.length())).startsWith("/")) {
                    realPath = realPath.substring(1);
                }
                if (realPath.endsWith(".json")) {
                    realPath = realPath.substring(0, realPath.length() - 5);
                }
                ResourceLocation realId = new ResourceLocation(id.func_110624_b(), realPath);
                IResource resource = rm.func_199002_a(id);
                InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8);
                JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                map.put((Object)realId, factory.apply(realId, json));
            }
            return map.build();
        }
        catch (IOException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public static List<ItemStack> loadStackList(IResourceManager rm, String path, String name) {
        try {
            ImmutableList.Builder list = ImmutableList.builder();
            for (String namespace : rm.func_199001_a()) {
                ResourceLocation id = new ResourceLocation(namespace, path + "/" + name + ".json");
                if (!rm.func_219533_b(id)) continue;
                IResource resource = rm.func_199002_a(id);
                InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8);
                JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                for (JsonElement elem : json.getAsJsonArray()) {
                    if (elem.isJsonObject() && elem.getAsJsonObject().has("mod") && !ModList.get().isLoaded(elem.getAsJsonObject().get("mod").getAsString())) continue;
                    try {
                        list.add((Object)CraftingHelper.getItemStack((JsonObject)elem.getAsJsonObject(), (boolean)true));
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {}
                }
            }
            return list.build();
        }
        catch (IOException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }
}

