/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.biome.biomes;

import com.feywild.feywild.config.MobConfig;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.world.biome.ModConfiguredSurfaceBuilders;
import com.feywild.feywild.world.biome.biomes.BiomeType;
import com.feywild.feywild.world.structure.ModConfiguredStructures;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;

public class SummerBiome
implements BiomeType {
    public static final SummerBiome INSTANCE = new SummerBiome();

    private SummerBiome() {
    }

    @Override
    public Biome.Category category() {
        return Biome.Category.SAVANNA;
    }

    @Override
    public Biome.RainType rain() {
        return Biome.RainType.NONE;
    }

    @Override
    public float scale() {
        return WorldGenConfig.biomes.summer.size;
    }

    @Override
    public float temperature() {
        return 0.9f;
    }

    @Override
    public float downfall() {
        return 0.0f;
    }

    @Override
    public ConfiguredSurfaceBuilder<?> surface() {
        return ModConfiguredSurfaceBuilders.SUMMER_SURFACE;
    }

    @Override
    public void ambience(BiomeAmbience.Builder builder) {
        builder.func_235246_b_(4159204);
        builder.func_235248_c_(329011);
        builder.func_235239_a_(12638463);
        builder.func_242539_d(BiomeMaker.func_244206_a((float)0.9f));
        builder.func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_197614_g, 0.001f));
    }

    @Override
    public void spawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_226289_e_, 20, 2, 3));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntityTypes.beeKnight, 2 * MobConfig.summer_bee_knight.weight, MobConfig.summer_bee_knight.min, MobConfig.summer_bee_knight.max));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntityTypes.summerPixie, 2 * MobConfig.summer_pixie.weight, MobConfig.summer_pixie.min, MobConfig.summer_pixie.max));
    }

    @Override
    public void generation(BiomeGenerationSettings.Builder builder) {
        DefaultBiomeFeatures.func_243696_J((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243700_N((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243698_L((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243719_ac((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243844_aq);
        DefaultBiomeFeatures.func_243751_k((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(ModConfiguredStructures.CONFIGURED_BEEKEEP);
        builder.func_242516_a(ModConfiguredStructures.CONFIGURED_SUMMER_WORLD_TREE);
    }

    @Override
    public void overworldSpawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_220350_aJ, 3, 2, 5));
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)builder);
    }

    @Override
    public void overworldGen(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(StructureFeatures.field_244135_a);
    }
}

