/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.structure;

import com.feywild.feywild.world.structure.structures.AutumnWorldTreeStructure;
import com.feywild.feywild.world.structure.structures.BaseStructure;
import com.feywild.feywild.world.structure.structures.BeekeepStructure;
import com.feywild.feywild.world.structure.structures.BlacksmithStructure;
import com.feywild.feywild.world.structure.structures.LibraryStructure;
import com.feywild.feywild.world.structure.structures.SpringWorldTreeStructure;
import com.feywild.feywild.world.structure.structures.SummerWorldTreeStructure;
import com.feywild.feywild.world.structure.structures.WinterWorldTreeStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class ModStructures {
    public static final BaseStructure springWorldTree = new SpringWorldTreeStructure();
    public static final BaseStructure summerWorldTree = new SummerWorldTreeStructure();
    public static final BaseStructure autumnWorldTree = new AutumnWorldTreeStructure();
    public static final BaseStructure winterWorldTree = new WinterWorldTreeStructure();
    public static final BaseStructure blacksmith = new BlacksmithStructure();
    public static final BaseStructure library = new LibraryStructure();
    public static final BaseStructure beekeep = new BeekeepStructure();

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand(springWorldTree, true);
        ModStructures.setupMapSpacingAndLand(summerWorldTree, true);
        ModStructures.setupMapSpacingAndLand(autumnWorldTree, true);
        ModStructures.setupMapSpacingAndLand(winterWorldTree, true);
        ModStructures.setupMapSpacingAndLand(library, true);
        ModStructures.setupMapSpacingAndLand(blacksmith, true);
        ModStructures.setupMapSpacingAndLand(beekeep, true);
    }

    public static void setupMapSpacingAndLand(BaseStructure structure, boolean transformSurroundingLand) {
        StructureSeparationSettings separationSettings = structure.getSettings();
        Structure.field_236365_a_.put((Object)Objects.requireNonNull(structure.getRegistryName()).toString(), (Object)structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object)structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)structure, (Object)separationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<BaseStructure, StructureSeparationSettings> tempMap = new HashMap<BaseStructure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, separationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = ImmutableMap.copyOf(tempMap);
            } else {
                structureMap.put(structure, separationSettings);
            }
        });
    }
}

