/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.structure.load;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.config.CompatConfig;
import com.feywild.feywild.entity.DwarfBlacksmithEntity;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.entity.base.TraderEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FeywildStructurePiece
extends SingleJigsawPiece {
    public static final ResourceLocation ID = new ResourceLocation(FeywildMod.getInstance().modid, "structure_piece");
    public static final Codec<FeywildStructurePiece> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FeywildStructurePiece.func_236846_c_(), (App)FeywildStructurePiece.func_236844_b_(), (App)FeywildStructurePiece.func_236848_d_()).apply((Applicative)builder, FeywildStructurePiece::new));
    public static final IJigsawDeserializer<FeywildStructurePiece> TYPE = () -> CODEC;

    protected FeywildStructurePiece(Either<ResourceLocation, Template> template, Supplier<StructureProcessorList> processors, JigsawPattern.PlacementBehaviour projection) {
        super(template, processors, projection);
    }

    public boolean func_230378_a_(@Nonnull TemplateManager templates, @Nonnull ISeedReader world, @Nonnull StructureManager structures2, @Nonnull ChunkGenerator generator, @Nonnull BlockPos fromPos, @Nonnull BlockPos toPos, @Nonnull Rotation rot, @Nonnull MutableBoundingBox box, @Nonnull Random random, boolean jigsaw) {
        PlacementSettings settings;
        Template template = (Template)this.field_236839_c_.map(arg_0 -> ((TemplateManager)templates).func_200220_a(arg_0), Function.identity());
        if (!template.func_237146_a_((IServerWorld)world, fromPos, toPos, settings = this.func_230379_a_(rot, box, jigsaw), random, 18)) {
            return false;
        }
        for (Template.BlockInfo info : Template.processBlockInfos((IWorld)world, (BlockPos)fromPos, (BlockPos)toPos, (PlacementSettings)settings, (List)this.func_214857_a(templates, fromPos, rot, false), (Template)template)) {
            this.handleCustomDataMarker(templates, structures2, world, info, info.field_186242_a, rot, random, box);
        }
        return true;
    }

    @Nonnull
    protected PlacementSettings func_230379_a_(@Nonnull Rotation rot, @Nonnull MutableBoundingBox box, boolean jigsaw) {
        PlacementSettings settings = super.func_230379_a_(rot, box, jigsaw);
        settings.func_215220_b((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        return settings;
    }

    public void handleCustomDataMarker(TemplateManager templates, StructureManager structures2, ISeedReader world, Template.BlockInfo block, BlockPos pos, Rotation rot, Random random, MutableBoundingBox box) {
        String data = block.field_186244_c == null ? "" : block.field_186244_c.func_74779_i("metadata");
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        if (data.equals("Waystone") && CompatConfig.waystones) {
            this.placePiece(templates, world, "waystone", pos, random);
        } else if (data.equals("Dwarf")) {
            this.placeDwarf(world, pos);
        } else if (data.equals("Brazier")) {
            this.placePiece(templates, world, "brazier", pos, random);
        }
        super.func_214846_a((IWorld)world, block, pos, rot, random, box);
    }

    @Nonnull
    public IJigsawDeserializer<?> func_214853_a() {
        return TYPE;
    }

    private void placePiece(TemplateManager templates, ISeedReader world, String name, BlockPos pos, Random random) {
        Template template = templates.func_200220_a(new ResourceLocation(FeywildMod.getInstance().modid, "parts/" + name));
        template.func_237152_b_((IServerWorld)world, pos, new PlacementSettings(), random);
    }

    private void placeDwarf(ISeedReader world, BlockPos pos) {
        if (CompatConfig.mythic_alfheim.locked) {
            world.func_180501_a(pos, ModBlocks.ancientRunestone.func_176223_P(), 2);
        } else {
            DwarfBlacksmithEntity entity = new DwarfBlacksmithEntity((EntityType<? extends TraderEntity>)ModEntityTypes.dwarfBlacksmith, (World)world.func_201672_e());
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            entity.setTamed(false);
            entity.func_110163_bv();
            this.addEntity(world, (Entity)entity);
        }
    }

    private void addEntity(ISeedReader world, Entity entity) {
        if (world instanceof WorldGenRegion) {
            int x = (int)Math.floor(entity.func_226277_ct_()) >> 4;
            int z = (int)Math.floor(entity.func_226281_cx_()) >> 4;
            if (((WorldGenRegion)world).func_201679_a() == x && ((WorldGenRegion)world).func_201680_b() == z) {
                world.func_217376_c(entity);
            }
        } else {
            world.func_217376_c(entity);
        }
    }
}

